/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tabularresultset;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.tabularresultset.TabularResultSetCommandsI18n;
import org.komodo.relational.commands.tabularresultset.TabularResultSetShellCommand;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.relational.model.TabularResultSet;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteColumnCommand
extends TabularResultSetShellCommand {
    static final String NAME = "delete-column";

    public DeleteColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnName = this.requiredArgument(0, I18n.bind((String)TabularResultSetCommandsI18n.missingColumnName, (Object[])new Object[0]));
            TabularResultSet resultSet = this.getTabularResultSet();
            resultSet.removeColumn(this.getTransaction(), columnName);
            result = new CommandResultImpl(I18n.bind((String)TabularResultSetCommandsI18n.columnDeleted, (Object[])new Object[]{columnName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.deleteColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.deleteColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.deleteColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        TabularResultSet resultSet = this.getTabularResultSet();
        ResultSetColumn[] columns = resultSet.getColumns(uow);
        ArrayList<String> existingColumnNames = new ArrayList<String>(columns.length);
        for (ResultSetColumn column : columns) {
            existingColumnNames.add(column.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingColumnNames);
            } else {
                for (String item : existingColumnNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

