/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.teiid;

import java.util.List;
import org.komodo.relational.commands.mask.MaskCommandsI18n;
import org.komodo.relational.commands.teiid.TeiidCommandsI18n;
import org.komodo.relational.commands.teiid.TeiidShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetTeiidPropertyCommand
extends TeiidShellCommand {
    static final String NAME = "set-property";

    public SetTeiidPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Teiid teiid = this.getTeiid();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "adminPort": {
                    try {
                        int port = Integer.parseInt(value);
                        teiid.setAdminPort(transaction, port);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"adminPort"});
                    }
                    break;
                }
                case "adminPswd": {
                    teiid.setAdminPassword(transaction, value);
                    break;
                }
                case "adminSecure": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        teiid.setAdminSecure(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"adminSecure"});
                    break;
                }
                case "adminUser": {
                    teiid.setAdminUser(transaction, value);
                    break;
                }
                case "jdbcPort": {
                    try {
                        int port = Integer.parseInt(value);
                        teiid.setJdbcPort(transaction, port);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"jdbcPort"});
                    }
                    break;
                }
                case "jdbcPswd": {
                    teiid.setJdbcPassword(transaction, value);
                    break;
                }
                case "jdbcSecure": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        teiid.setJdbcSecure(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"jdbcSecure"});
                    break;
                }
                case "jdbcUser": {
                    teiid.setJdbcUsername(transaction, value);
                    break;
                }
                case "host": {
                    teiid.setHost(transaction, value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Teiid.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TeiidCommandsI18n.setTeiidPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TeiidCommandsI18n.setTeiidPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)MaskCommandsI18n.setMaskPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && ("adminSecure".equals(this.getArguments().get(0)) || "jdbcSecure".equals(this.getArguments().get(0)))) {
            this.updateCandidatesForBooleanProperty(lastArgument, candidates);
        }
        return TabCompletionModifier.AUTO;
    }
}

