/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.teiid;

import java.util.List;
import org.komodo.relational.commands.teiid.TeiidCommandsI18n;
import org.komodo.relational.commands.teiid.TeiidShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidAdminInfo;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetTeiidPropertyCommand
extends TeiidShellCommand {
    static final String NAME = "unset-property";

    public UnsetTeiidPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            Teiid teiid = this.getTeiid();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "adminPort": {
                    TeiidVersion teiidVersion = TeiidVersionProvider.getInstance().getTeiidVersion();
                    teiid.setAdminPort(transaction, TeiidAdminInfo.Util.defaultPort((TeiidVersion)teiidVersion));
                    break;
                }
                case "adminPswd": {
                    teiid.setAdminPassword(transaction, null);
                    break;
                }
                case "adminSecure": {
                    teiid.setAdminSecure(transaction, true);
                    break;
                }
                case "adminUser": {
                    teiid.setAdminUser(transaction, null);
                    break;
                }
                case "jdbcPort": {
                    teiid.setJdbcPort(transaction, 31000);
                    break;
                }
                case "jdbcPswd": {
                    teiid.setJdbcPassword(transaction, null);
                    break;
                }
                case "jdbcSecure": {
                    teiid.setJdbcSecure(transaction, false);
                    break;
                }
                case "jdbcUser": {
                    teiid.setJdbcUsername(transaction, null);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Teiid.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TeiidCommandsI18n.unsetTeiidPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TeiidCommandsI18n.unsetTeiidPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TeiidCommandsI18n.unsetTeiidPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

