/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.userdefinedfunction;

import java.util.List;
import org.komodo.relational.commands.userdefinedfunction.UserDefinedFunctionCommandsI18n;
import org.komodo.relational.commands.userdefinedfunction.UserDefinedFunctionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.SchemaElement;
import org.komodo.relational.model.UserDefinedFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetUserDefinedFunctionPropertyCommand
extends UserDefinedFunctionShellCommand {
    static final String NAME = "set-property";

    public SetUserDefinedFunctionPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            UserDefinedFunction func = this.getUserDefinedFunction();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "AGGREGATE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setAggregate(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"AGGREGATE"});
                    break;
                }
                case "ALLOWS_DISTINCT": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setAllowsDistinct(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"ALLOWS_DISTINCT"});
                    break;
                }
                case "ALLOWS_ORDERBY": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setAllowsOrderBy(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"ALLOWS_ORDERBY"});
                    break;
                }
                case "ANALYTIC": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setAnalytic(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"ANALYTIC"});
                    break;
                }
                case "CATEGORY": {
                    func.setCategory(this.getTransaction(), value);
                    break;
                }
                case "DECOMPOSABLE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setDecomposable(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"DECOMPOSABLE"});
                    break;
                }
                case "ANNOTATION": {
                    func.setDescription(this.getTransaction(), value);
                    break;
                }
                case "DETERMINISM": {
                    if (Function.Determinism.COMMAND_DETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.COMMAND_DETERMINISTIC);
                        break;
                    }
                    if (Function.Determinism.DETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.DETERMINISTIC);
                        break;
                    }
                    if (Function.Determinism.NONDETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.NONDETERMINISTIC);
                        break;
                    }
                    if (Function.Determinism.SESSION_DETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.SESSION_DETERMINISTIC);
                        break;
                    }
                    if (Function.Determinism.USER_DETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.USER_DETERMINISTIC);
                        break;
                    }
                    if (Function.Determinism.VDB_DETERMINISTIC.name().equals(value)) {
                        func.setDeterminism(transaction, Function.Determinism.VDB_DETERMINISTIC);
                        break;
                    }
                    errorMsg = I18n.bind((String)UserDefinedFunctionCommandsI18n.invalidDeterministicPropertyValue, (Object[])new Object[]{"DETERMINISM"});
                    break;
                }
                case "JAVA_CLASS": {
                    func.setJavaClass(this.getTransaction(), value);
                    break;
                }
                case "JAVA_METHOD": {
                    func.setJavaMethod(this.getTransaction(), value);
                    break;
                }
                case "NAMEINSOURCE": {
                    func.setNameInSource(this.getTransaction(), value);
                    break;
                }
                case "NULL_ON_NULL": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setNullOnNull(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"NULL_ON_NULL"});
                    break;
                }
                case "schemaElementType": {
                    if (SchemaElement.SchemaElementType.FOREIGN.name().equals(value)) {
                        func.setSchemaElementType(transaction, SchemaElement.SchemaElementType.FOREIGN);
                        break;
                    }
                    if (SchemaElement.SchemaElementType.VIRTUAL.name().equals(value)) {
                        func.setSchemaElementType(transaction, SchemaElement.SchemaElementType.VIRTUAL);
                        break;
                    }
                    errorMsg = I18n.bind((String)UserDefinedFunctionCommandsI18n.invalidSchemaElementTypePropertyValue, (Object[])new Object[]{"schemaElementType"});
                    break;
                }
                case "UPDATECOUNT": {
                    try {
                        long count = Long.parseLong(value);
                        func.setUpdateCount(transaction, count);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"UPDATECOUNT"});
                    }
                    break;
                }
                case "USES_DISTINCT_ROWS": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setUsesDistinctRows(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"USES_DISTINCT_ROWS"});
                    break;
                }
                case "UUID": {
                    func.setUuid(this.getTransaction(), value);
                    break;
                }
                case "VARARGS": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        func.setVarArgs(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"VARARGS"});
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, UserDefinedFunction.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)UserDefinedFunctionCommandsI18n.setUserDefinedFunctionPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)UserDefinedFunctionCommandsI18n.setUserDefinedFunctionPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)UserDefinedFunctionCommandsI18n.setUserDefinedFunctionPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("AGGREGATE".equals(theArg) || "ALLOWS_DISTINCT".equals(theArg) || "ALLOWS_ORDERBY".equals(theArg) || "ANALYTIC".equals(theArg) || "DECOMPOSABLE".equals(theArg) || "NULL_ON_NULL".equals(theArg) || "USES_DISTINCT_ROWS".equals(theArg) || "VARARGS".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("DETERMINISM".equals(theArg)) {
                candidates.add(Function.Determinism.COMMAND_DETERMINISTIC.name());
                candidates.add(Function.Determinism.DETERMINISTIC.name());
                candidates.add(Function.Determinism.NONDETERMINISTIC.name());
                candidates.add(Function.Determinism.SESSION_DETERMINISTIC.name());
                candidates.add(Function.Determinism.USER_DETERMINISTIC.name());
                candidates.add(Function.Determinism.VDB_DETERMINISTIC.name());
            } else if ("schemaElementType".equals(theArg)) {
                candidates.add(SchemaElement.SchemaElementType.FOREIGN.name());
                candidates.add(SchemaElement.SchemaElementType.VIRTUAL.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

