/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddDataRoleCommand
extends VdbShellCommand {
    static final String NAME = "add-data-role";

    public AddDataRoleCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String dataRoleName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingDataRoleName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            DataRole[] roles = vdb.getDataRoles(this.getTransaction(), new String[]{dataRoleName});
            if (roles.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{dataRoleName, DataRole.class.getSimpleName()}), null);
            }
            vdb.addDataRole(this.getTransaction(), dataRoleName);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.dataRoleAdded, (Object[])new Object[]{dataRoleName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addDataRoleHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addDataRoleExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addDataRoleUsage, (Object[])new Object[0]), new Object[0]);
    }
}

