/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.Entry;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddEntryCommand
extends VdbShellCommand {
    static final String NAME = "add-entry";

    public AddEntryCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String entryName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingEntryName, (Object[])new Object[0]));
            String entryPath = this.requiredArgument(1, I18n.bind((String)VdbCommandsI18n.missingEntryPath, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            Entry[] entries = vdb.getEntries(this.getTransaction(), new String[]{entryName});
            if (entries.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{entryName, Entry.class.getSimpleName()}), null);
            }
            vdb.addEntry(this.getTransaction(), entryName, entryPath);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.entryAdded, (Object[])new Object[]{entryName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    public boolean isEnabled() {
        return false;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addEntryHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addEntryExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addEntryUsage, (Object[])new Object[0]), new Object[0]);
    }
}

