/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddImportCommand
extends VdbShellCommand {
    static final String NAME = "add-import";

    public AddImportCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String importName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingImportName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            VdbImport[] imports = vdb.getImports(this.getTransaction(), new String[]{importName});
            if (imports.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{importName, VdbImport.class.getSimpleName()}), null);
            }
            vdb.addImport(this.getTransaction(), importName);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.importAdded, (Object[])new Object[]{importName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addImportHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addImportExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addImportUsage, (Object[])new Object[0]), new Object[0]);
    }
}

