/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddModelCommand
extends VdbShellCommand {
    static final String NAME = "add-model";

    public AddModelCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String modelName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingModelName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            Model[] models = vdb.getModels(this.getTransaction(), new String[]{modelName});
            if (models.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{modelName, Model.class.getSimpleName()}), null);
            }
            vdb.addModel(this.getTransaction(), modelName);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.modelAdded, (Object[])new Object[]{modelName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addModelHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addModelExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.addModelUsage, (Object[])new Object[0]), new Object[0]);
    }
}

