/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.Entry;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteEntryCommand
extends VdbShellCommand {
    static final String NAME = "delete-entry";

    public DeleteEntryCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String entryName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingEntryName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            vdb.removeEntry(this.getTransaction(), entryName);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.entryDeleted, (Object[])new Object[]{entryName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    public boolean isEnabled() {
        return false;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteEntryHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteEntryExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteEntryUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Vdb vdb = this.getVdb();
        Entry[] entries = vdb.getEntries(uow, new String[0]);
        ArrayList<String> existingEntryNames = new ArrayList<String>(entries.length);
        for (Entry entry : entries) {
            existingEntryNames.add(entry.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingEntryNames);
            } else {
                for (String item : existingEntryNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

