/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public class DeleteTranslatorCommand
extends VdbShellCommand {
    static final String NAME = "delete-translator";

    public DeleteTranslatorCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String translatorName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingTranslatorName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            vdb.removeTranslator(this.getTransaction(), translatorName);
            result = new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.translatorDeleted, (Object[])new Object[]{translatorName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteTranslatorHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteTranslatorExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.deleteTranslatorUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Vdb vdb = this.getVdb();
        Translator[] translators = vdb.getTranslators(uow, new String[0]);
        ArrayList<String> existingTranslatorNames = new ArrayList<String>(translators.length);
        for (Translator translator : translators) {
            existingTranslatorNames.add(translator.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingTranslatorNames);
            } else {
                for (String item : existingTranslatorNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

