/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.List;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetVdbPropertyCommand
extends VdbShellCommand {
    static final String NAME = "set-property";

    public SetVdbPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "allowed-languages": {
                    vdb.setAllowedLanguages(transaction, value);
                    break;
                }
                case "authentication-type": {
                    vdb.setAuthenticationType(transaction, value);
                    break;
                }
                case "connectionType": {
                    vdb.setConnectionType(transaction, value);
                    break;
                }
                case "description": {
                    vdb.setDescription(transaction, value);
                    break;
                }
                case "gss-pattern": {
                    vdb.setGssPattern(transaction, value);
                    break;
                }
                case "originalFile": {
                    vdb.setOriginalFilePath(transaction, value);
                    break;
                }
                case "password-pattern": {
                    vdb.setPasswordPattern(transaction, value);
                    break;
                }
                case "preview": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        vdb.setPreview(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"preview"});
                    break;
                }
                case "query-timeout": {
                    try {
                        int timeout = Integer.parseInt(value);
                        vdb.setQueryTimeout(transaction, timeout);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"query-timeout"});
                    }
                    break;
                }
                case "security-domain": {
                    vdb.setSecurityDomain(transaction, value);
                    break;
                }
                case "version": {
                    try {
                        int version = Integer.parseInt(value);
                        vdb.setVersion(transaction, version);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"version"});
                    }
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Vdb.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.setVdbPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.setVdbPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.setVdbPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && "preview".equals(this.getArguments().get(0))) {
            this.updateCandidatesForBooleanProperty(lastArgument, candidates);
        }
        return TabCompletionModifier.AUTO;
    }
}

