/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowImportsCommand
extends VdbShellCommand {
    static final String NAME = "show-imports";

    public ShowImportsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Vdb vdb = this.getVdb();
            VdbImport[] imports = vdb.getImports(this.getTransaction(), namePatterns);
            if (imports.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.noMatchingImports, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.noImports, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.matchingImportsHeader, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.importsHeader, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (VdbImport theImport : imports) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{theImport.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)theImport, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showImportsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showImportsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showImportsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

