/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowModelsCommand
extends VdbShellCommand {
    static final String NAME = "show-models";

    public ShowModelsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Vdb vdb = this.getVdb();
            Model[] models = vdb.getModels(this.getTransaction(), namePatterns);
            if (models.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.noMatchingModels, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.noModels, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.matchingModelsHeader, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)VdbCommandsI18n.modelsHeader, (Object[])new Object[]{vdb.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Model model : models) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{model.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)model, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showModelsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showModelsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.showModelsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

