/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.List;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetVdbPropertyCommand
extends VdbShellCommand {
    static final String NAME = "unset-property";

    public UnsetVdbPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            Vdb vdb = this.getVdb();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "allowed-languages": {
                    vdb.setAllowedLanguages(transaction, null);
                    break;
                }
                case "authentication-type": {
                    vdb.setAuthenticationType(transaction, null);
                    break;
                }
                case "connectionType": {
                    vdb.setConnectionType(transaction, null);
                    break;
                }
                case "description": {
                    vdb.setDescription(transaction, null);
                    break;
                }
                case "gss-pattern": {
                    vdb.setGssPattern(transaction, null);
                    break;
                }
                case "originalFile": {
                    vdb.setOriginalFilePath(transaction, null);
                    break;
                }
                case "password-pattern": {
                    vdb.setPasswordPattern(transaction, null);
                    break;
                }
                case "preview": {
                    vdb.setPreview(transaction, false);
                    break;
                }
                case "query-timeout": {
                    vdb.setQueryTimeout(transaction, -1);
                    break;
                }
                case "security-domain": {
                    vdb.setSecurityDomain(transaction, null);
                    break;
                }
                case "version": {
                    vdb.setVersion(transaction, 1);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Vdb.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.unsetVdbPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.unsetVdbPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.unsetVdbPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

