/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UploadModelCommand
extends VdbShellCommand {
    static final String NAME = "upload-model";
    private static final List<String> VALID_ARGS = Arrays.asList("-o", "--overwrite");

    public UploadModelCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            boolean overwrite;
            String modelName = this.requiredArgument(0, I18n.bind((String)VdbCommandsI18n.missingModelNameForUpload, (Object[])new Object[0]));
            String modelType = this.requiredArgument(1, I18n.bind((String)VdbCommandsI18n.missingModelType, (Object[])new Object[0]));
            String fileName = this.requiredArgument(2, I18n.bind((String)VdbCommandsI18n.missingInputModelFilePath, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(3, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (!modelType.equals(Model.Type.PHYSICAL.name()) && !modelType.equals(Model.Type.VIRTUAL.name())) {
                return new CommandResultImpl(false, I18n.bind((String)VdbCommandsI18n.modelTypeError, (Object[])new Object[]{modelType}), null);
            }
            if (overwrite && !VALID_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)VdbCommandsI18n.invalidOverwriteArg, (Object[])new Object[]{overwriteArg}), null);
            }
            String validationResult = this.validateReadableFileArg(fileName);
            if (!"OK".equals(validationResult)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
            if (StringUtils.isEmpty((String)content)) {
                return new CommandResultImpl(false, I18n.bind((String)VdbCommandsI18n.modelInputFileIsEmpty, (Object[])new Object[]{fileName}), null);
            }
            Repository.UnitOfWork uow = this.getTransaction();
            Vdb vdbContext = (Vdb)this.getContext();
            Model[] allModels = vdbContext.getModels(uow, new String[0]);
            boolean hasModel = false;
            for (Model theModel : allModels) {
                if (!modelName.equals(theModel.getName(uow))) continue;
                hasModel = true;
                break;
            }
            if (hasModel && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)VdbCommandsI18n.modelOverwriteDisabled, (Object[])new Object[]{fileName}), null);
            }
            Model model = vdbContext.addModel(uow, modelName);
            model.setModelType(uow, Model.Type.valueOf((String)modelType));
            model.setModelDefinition(uow, content);
            model.setProperty(uow, "ddl:parserId", new Object[]{"TEIID"});
            return new CommandResultImpl(I18n.bind((String)VdbCommandsI18n.modelUploaded, (Object[])new Object[]{modelName}));
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return 4;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.uploadModelHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.uploadModelExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.uploadModelUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.size() == 1) {
            if (lastArgument == null) {
                candidates.add(Model.Type.PHYSICAL.name());
                candidates.add(Model.Type.VIRTUAL.name());
            } else if (Model.Type.PHYSICAL.name().toUpperCase().startsWith(lastArgument.toUpperCase())) {
                candidates.add(Model.Type.PHYSICAL.name());
            } else if (Model.Type.VIRTUAL.name().toUpperCase().startsWith(lastArgument.toUpperCase())) {
                candidates.add(Model.Type.VIRTUAL.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

