/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.relational.commands.vdb.VdbCommandsI18n;
import org.komodo.relational.commands.vdb.VdbShellCommand;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.validation.Result;
import org.komodo.utils.i18n.I18n;

public final class ValidateVdbCommand
extends VdbShellCommand {
    static final String NAME = "validate-vdb";

    public ValidateVdbCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        boolean fullValidation = Boolean.getBoolean(this.optionalArgument(0, "true"));
        try {
            Vdb vdb = this.getVdb();
            String vdbName = vdb.getName(this.getTransaction());
            Result[] results = this.getRepository().getValidationManager().evaluate(this.getTransaction(), (KomodoObject)vdb, fullValidation);
            boolean hasErrors = this.hasLevel(results, Outcome.Level.ERROR);
            boolean hasWarnings = this.hasLevel(results, Outcome.Level.WARNING);
            if (!hasErrors && !hasWarnings) {
                this.print(5, I18n.bind((String)VdbCommandsI18n.vdbValidationSuccessMsg, (Object[])new Object[]{vdbName}), new Object[0]);
                return CommandResult.SUCCESS;
            }
            if (hasErrors) {
                this.print(5, I18n.bind((String)VdbCommandsI18n.vdbValidationErrorsHeader, (Object[])new Object[]{vdbName}), new Object[0]);
                for (Result result : results) {
                    if (result.getLevel() != Outcome.Level.ERROR) continue;
                    this.print(5, result.getMessage(), new Object[0]);
                }
            }
            if (hasWarnings) {
                this.print(5, I18n.bind((String)VdbCommandsI18n.vdbValidationWarningsHeader, (Object[])new Object[]{vdbName}), new Object[0]);
                for (Result result : results) {
                    if (result.getLevel() != Outcome.Level.ERROR) continue;
                    this.print(5, result.getMessage(), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    private boolean hasLevel(Result[] results, Outcome.Level outcome) {
        for (Result result : results) {
            if (result.getLevel() != outcome) continue;
            return true;
        }
        return false;
    }

    protected int getMaxArgCount() {
        return 0;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.validateVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.validateVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VdbCommandsI18n.validateVdbUsage, (Object[])new Object[0]), new Object[0]);
    }
}

