/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.virtualprocedure;

import java.util.List;
import org.komodo.relational.commands.virtualprocedure.VirtualProcedureCommandsI18n;
import org.komodo.relational.commands.virtualprocedure.VirtualProcedureShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.SchemaElement;
import org.komodo.relational.model.VirtualProcedure;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetVirtualProcedurePropertyCommand
extends VirtualProcedureShellCommand {
    static final String NAME = "set-property";

    public SetVirtualProcedurePropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            VirtualProcedure proc = this.getVirtualProcedure();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "as-clause-statement": {
                    proc.setAsClauseStatement(this.getTransaction(), value);
                    break;
                }
                case "description": {
                    proc.setDescription(this.getTransaction(), value);
                    break;
                }
                case "name-in-source": {
                    proc.setNameInSource(this.getTransaction(), value);
                    break;
                }
                case "schema-element-type": {
                    if (SchemaElement.SchemaElementType.FOREIGN.name().equals(value)) {
                        proc.setSchemaElementType(transaction, SchemaElement.SchemaElementType.FOREIGN);
                        break;
                    }
                    if (SchemaElement.SchemaElementType.VIRTUAL.name().equals(value)) {
                        proc.setSchemaElementType(transaction, SchemaElement.SchemaElementType.VIRTUAL);
                        break;
                    }
                    errorMsg = I18n.bind((String)VirtualProcedureCommandsI18n.invalidSchemaElementTypePropertyValue, (Object[])new Object[]{value});
                    break;
                }
                case "update-count": {
                    try {
                        long count = Long.parseLong(value);
                        proc.setUpdateCount(transaction, count);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{value});
                    }
                    break;
                }
                case "uuid": {
                    proc.setUuid(this.getTransaction(), value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, VirtualProcedure.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)VirtualProcedureCommandsI18n.setVirtualProcedurePropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)VirtualProcedureCommandsI18n.setVirtualProcedurePropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)VirtualProcedureCommandsI18n.setVirtualProcedurePropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        String theArg;
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && "schema-element-type".equals(theArg = (String)this.getArguments().get(0))) {
            candidates.add(SchemaElement.SchemaElementType.FOREIGN.name());
            candidates.add(SchemaElement.SchemaElementType.VIRTUAL.name());
        }
        return TabCompletionModifier.AUTO;
    }
}

