/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.KomodoObjectUtils;
import org.komodo.utils.i18n.I18n;

public final class CreateConnectionCommand
extends WorkspaceShellCommand {
    static final String NAME = "create-connection";

    public CreateConnectionCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String sourceName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingConnectionName, (Object[])new Object[0]));
            String isJdbc = this.optionalArgument(1, Boolean.TRUE.toString());
            if (!KomodoObjectUtils.TRUE_STRING.equals(isJdbc) && !KomodoObjectUtils.FALSE_STRING.equals(isJdbc)) {
                return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.invalidConnectionIndicator, (Object[])new Object[]{isJdbc}));
            }
            WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
            if (mgr.hasChild(this.getTransaction(), sourceName, "dv:connection")) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotCreateChildAlreadyExistsError, (Object[])new Object[]{sourceName, Connection.class.getSimpleName()}), null);
            }
            Connection connection = mgr.createConnection(this.getTransaction(), null, sourceName);
            connection.setJdbc(this.getTransaction(), Boolean.parseBoolean(isJdbc));
            result = new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.connectionCreated, (Object[])new Object[]{sourceName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createConnectionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createConnectionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createConnectionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

