/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import javax.xml.validation.Schema;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class CreateSchemaCommand
extends WorkspaceShellCommand {
    public static final String NAME = "create-schema";

    public CreateSchemaCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String schemaName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingSchemaName, (Object[])new Object[0]));
            WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
            if (mgr.hasChild(this.getTransaction(), schemaName, "tko:schema")) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotCreateChildAlreadyExistsError, (Object[])new Object[]{schemaName, Schema.class.getSimpleName()}), null);
            }
            mgr.createSchema(this.getTransaction(), null, schemaName);
            result = new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.schemaCreated, (Object[])new Object[]{schemaName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createSchemaHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createSchemaExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createSchemaUsage, (Object[])new Object[0]), new Object[0]);
    }
}

