/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import org.komodo.core.KomodoLexicon;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class CreateVdbCommand
extends WorkspaceShellCommand {
    static final String NAME = "create-vdb";
    static final String DEFAULT_PATH = "defaultPath";

    public CreateVdbCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String vdbName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingVdbName, (Object[])new Object[0]));
            String extPath = this.optionalArgument(1, DEFAULT_PATH);
            WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
            if (mgr.hasChild(this.getTransaction(), vdbName, "vdb:virtualDatabase")) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotCreateChildAlreadyExistsError, (Object[])new Object[]{vdbName, KomodoLexicon.Vdb.class.getSimpleName()}), null);
            }
            mgr.createVdb(this.getTransaction(), null, vdbName, extPath);
            result = new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.vdbCreated, (Object[])new Object[]{vdbName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.createVdbUsage, (Object[])new Object[0]), new Object[0]);
    }
}

