/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteConnectionCommand
extends WorkspaceShellCommand {
    static final String NAME = "delete-connection";

    public DeleteConnectionCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            String connectionName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingConnectionName, (Object[])new Object[0]));
            KomodoObject connectionToDelete = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), connectionName, "dv:connection");
            if (connectionToDelete == null) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.connectionNotFound, (Object[])new Object[]{connectionName}), null);
            }
            this.getWorkspaceManager(this.getTransaction()).delete(this.getTransaction(), new KomodoObject[]{connectionToDelete});
            return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.connectionDeleted, (Object[])new Object[]{connectionName}));
        }
        catch (Exception e) {
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.deleteConnectionError, (Object[])new Object[0]), e);
        }
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteConnectionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteConnectionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteConnectionUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
        Connection[] connections = mgr.findConnections(this.getTransaction());
        ArrayList<String> existingNames = new ArrayList<String>(connections.length);
        for (Connection connection : connections) {
            existingNames.add(connection.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingNames);
            } else {
                for (String item : existingNames) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

