/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.model.Schema;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteSchemaCommand
extends WorkspaceShellCommand {
    static final String NAME = "delete-schema";

    public DeleteSchemaCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            String schemaName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingSchemaName, (Object[])new Object[0]));
            KomodoObject schemaToDelete = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), schemaName, "tko:schema");
            if (schemaToDelete == null) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.schemaNotFound, (Object[])new Object[]{schemaName}), null);
            }
            this.getWorkspaceManager(this.getTransaction()).delete(this.getTransaction(), new KomodoObject[]{schemaToDelete});
            return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.schemaDeleted, (Object[])new Object[]{schemaName}));
        }
        catch (Exception e) {
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.deleteSchemaError, (Object[])new Object[0]), e);
        }
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteSchemaHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteSchemaExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteSchemaUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
        Schema[] schemas = mgr.findSchemas(this.getTransaction());
        ArrayList<String> existingSchemaNames = new ArrayList<String>(schemas.length);
        for (Schema schema : schemas) {
            existingSchemaNames.add(schema.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingSchemaNames);
            } else {
                for (String item : existingSchemaNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

