/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteVdbCommand
extends WorkspaceShellCommand {
    static final String NAME = "delete-vdb";

    public DeleteVdbCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            String vdbName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingVdbName, (Object[])new Object[0]));
            KomodoObject vdbToDelete = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), vdbName, "vdb:virtualDatabase");
            if (vdbToDelete == null) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.vdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            this.getWorkspaceManager(this.getTransaction()).delete(this.getTransaction(), new KomodoObject[]{vdbToDelete});
            return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.vdbDeleted, (Object[])new Object[]{vdbName}));
        }
        catch (Exception e) {
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.deleteVdbError, (Object[])new Object[0]), e);
        }
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.deleteVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
        Vdb[] vdbs = mgr.findVdbs(uow);
        ArrayList<String> existingVdbNames = new ArrayList<String>(vdbs.length);
        for (Vdb vdb : vdbs) {
            existingVdbNames.add(vdb.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingVdbNames);
            } else {
                for (String item : existingVdbNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

