/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Vdb;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ExportVdbCommand
extends RelationalShellCommand {
    static final String NAME = "export-vdb";
    private static final String OVERWRITE_1 = "-o";
    private static final String OVERWRITE_2 = "--overwrite";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public ExportVdbCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        boolean workspaceContext = this.isWorkspaceContext();
        int fileNameIndex = workspaceContext ? 1 : 0;
        String vdbName = null;
        String fileName = null;
        try {
            String overwriteArg;
            boolean overwrite;
            vdbName = workspaceContext ? this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingVdbName, (Object[])new Object[0])) : this.getContext().getName(this.getTransaction());
            fileName = this.requiredArgument(fileNameIndex, I18n.bind((String)WorkspaceCommandsI18n.missingOutputFileName, (Object[])new Object[0]));
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + "xml";
            }
            boolean bl = overwrite = !StringUtils.isBlank((String)(overwriteArg = this.optionalArgument(fileNameIndex + 1, null)));
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            if (workspaceContext && !this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), vdbName, "vdb:virtualDatabase")) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.vdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            Vdb vdbToExport = this.getVdb(workspaceContext, vdbName);
            File file = new File(fileName);
            if (file.exists() && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.fileExistsOverwriteDisabled, (Object[])new Object[]{fileName}), null);
            }
            if (file.createNewFile() || file.exists() && overwrite) {
                Repository.UnitOfWork uow = this.getTransaction();
                Properties properties = new Properties();
                properties.put("useTabs", (Object)true);
                byte[] manifestBytes = vdbToExport.export(uow, properties);
                String manifest = new String(manifestBytes);
                try {
                    Files.write(Paths.get(file.getPath(), new String[0]), manifest.getBytes(), new OpenOption[0]);
                    return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.vdbExported, (Object[])new Object[]{vdbToExport.getName(uow), fileName, overwrite}));
                }
                catch (Exception e) {
                    return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.errorWritingFile, (Object[])new Object[]{fileName}), e);
                }
            }
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.outputFileError, (Object[])new Object[]{fileName}), null);
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return this.isWorkspaceContext() ? 3 : 2;
    }

    private Vdb getVdb(boolean workspaceContext, String vdbName) throws KException {
        assert (!StringUtils.isBlank((String)vdbName));
        KomodoObject kobject = null;
        kobject = workspaceContext ? this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), vdbName, "vdb:virtualDatabase") : this.getContext();
        assert (kobject != null);
        return (Vdb)Vdb.RESOLVER.resolve(this.getTransaction(), kobject);
    }

    public boolean isValidForCurrentContext() {
        return this.isVdbContext() || this.isWorkspaceContext();
    }

    private boolean isVdbContext() {
        try {
            return Vdb.RESOLVER.resolvable(this.getTransaction(), this.getContext());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isWorkspaceContext() {
        String path = this.getContext().getAbsolutePath();
        return this.getWorkspaceStatus().getLabelProvider().isWorkspacePath(path);
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.exportVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.exportVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.exportVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (this.isWorkspaceContext()) {
            Vdb[] vdbs = this.getWorkspaceManager(this.getTransaction()).findVdbs(this.getTransaction());
            if (args.isEmpty() && vdbs.length != 0) {
                for (Vdb vdb : vdbs) {
                    String name = vdb.getName(this.getTransaction());
                    if (lastArgument != null && !name.startsWith(lastArgument)) continue;
                    candidates.add(name);
                }
            } else if (args.size() == 2) {
                candidates.add(OVERWRITE_2);
            }
        } else if (args.size() == 1) {
            candidates.add(OVERWRITE_2);
        }
        return TabCompletionModifier.AUTO;
    }
}

