/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.relational.commands.workspace.DeleteVdbCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.importer.vdb.VdbImporter;
import org.komodo.relational.vdb.Vdb;
import org.komodo.repository.SynchronousCallback;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.ShellI18n;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class ImportVdbCommand
extends WorkspaceShellCommand {
    static final String NAME = "import-vdb";

    public ImportVdbCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            String validationResult;
            String fileName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingInputFileName, (Object[])new Object[0]));
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + "ddl";
            }
            if (!"OK".equals(validationResult = this.validateReadableFileArg(fileName))) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            File vdbFile = new File(fileName);
            ImportOptions importOptions = new ImportOptions();
            importOptions.setOption(ImportOptions.OptionKeys.NAME, (Object)vdbFile.getName());
            String validationMessage = this.validateNotDuplicate(vdbFile.getName(), KomodoType.VDB, this.getContext());
            if (!"OK".equals(validationMessage)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            ImportMessages importMessages = new ImportMessages();
            this.importVdb(this.getTransaction(), vdbFile, this.getContext(), importOptions, importMessages);
            if (!importMessages.hasError()) {
                this.print(5, I18n.bind((String)WorkspaceCommandsI18n.vdbImportInProgressMsg, (Object[])new Object[]{vdbFile}), new Object[0]);
                KomodoObject theVdb = null;
                this.commitImport(ImportVdbCommand.class.getSimpleName(), importMessages);
                if (!importMessages.hasError()) {
                    KomodoObject parentObj = this.getContext();
                    theVdb = parentObj.getChild(this.getTransaction(), vdbFile.getName(), "vdb:virtualDatabase");
                    if (theVdb == null) {
                        return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.importFailedMsg, (Object[])new Object[]{fileName}), null);
                    }
                    String vdbName = ((Vdb)theVdb).getVdbName(this.getTransaction());
                    validationResult = this.validateNotDuplicate(vdbName, KomodoType.VDB, parentObj);
                    if (!"OK".equals(validationResult)) {
                        CommandResult deleteResult = this.deleteVdb(theVdb.getName(this.getTransaction()));
                        if (deleteResult != null) {
                            return deleteResult;
                        }
                    } else {
                        theVdb.rename(this.getTransaction(), vdbName);
                        this.print(5, I18n.bind((String)WorkspaceCommandsI18n.vdbImportSuccessMsg, (Object[])new Object[]{fileName}), new Object[0]);
                    }
                } else {
                    this.print(5, I18n.bind((String)WorkspaceCommandsI18n.importFailedMsg, (Object[])new Object[]{fileName}), new Object[0]);
                    this.print(5, importMessages.errorMessagesToString(), new Object[0]);
                    CommandResult deleteResult = this.deleteVdb(vdbFile.getName());
                    if (deleteResult != null) {
                        return deleteResult;
                    }
                }
            } else {
                this.print(5, I18n.bind((String)WorkspaceCommandsI18n.importFailedMsg, (Object[])new Object[]{fileName}), new Object[0]);
                this.print(5, importMessages.errorMessagesToString(), new Object[0]);
            }
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName}), null);
        }
        catch (Exception e) {
            return new CommandResultImpl(false, I18n.bind((String)ShellI18n.commandFailure, (Object[])new Object[]{NAME}), e);
        }
    }

    private void importVdb(Repository.UnitOfWork uow, File vdbFile, KomodoObject parentObj, ImportOptions importOptions, ImportMessages importMessages) {
        Repository repository = null;
        try {
            repository = this.getRepository();
        }
        catch (Exception ex) {
            importMessages.addErrorMessage(ex.getLocalizedMessage());
        }
        VdbImporter importer = new VdbImporter(repository);
        importer.importVdb(uow, vdbFile, parentObj, importOptions, importMessages);
    }

    private void commitImport(String source, ImportMessages importMessages) throws Exception {
        boolean success;
        Repository.UnitOfWork trans = this.getTransaction();
        String txName = trans.getName();
        trans.commit();
        Repository.UnitOfWorkListener uowListener = trans.getCallback();
        SynchronousCallback callback = null;
        if (uowListener != null && uowListener instanceof SynchronousCallback) {
            callback = (SynchronousCallback)uowListener;
        }
        if (success = callback.await(3L, TimeUnit.MINUTES)) {
            if (callback.hasError()) {
                importMessages.addErrorMessage(callback.error());
                return;
            }
            KException error = trans.getError();
            Repository.UnitOfWork.State txState = trans.getState();
            if (error != null || !Repository.UnitOfWork.State.COMMITTED.equals((Object)txState)) {
                throw new KException(I18n.bind((String)ShellI18n.transactionCommitError, (Object[])new Object[]{txName}), (Throwable)error);
            }
        } else {
            throw new KException(I18n.bind((String)ShellI18n.transactionTimeout, (Object[])new Object[]{txName}));
        }
    }

    private CommandResult deleteVdb(String vdbName) {
        CommandResultImpl result = null;
        DeleteVdbCommand deleteCommand = new DeleteVdbCommand(this.getWorkspaceStatus());
        try {
            deleteCommand.setArguments(new Arguments(vdbName));
            deleteCommand.execute();
        }
        catch (Exception e) {
            result = new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.deleteTempVdbFailedMsg, (Object[])new Object[]{vdbName}), null);
        }
        return result;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.importVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.importVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.importVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    private String validateNotDuplicate(String objName, KomodoType kType, KomodoObject parentObj) throws Exception {
        KomodoObject[] children = parentObj.getChildrenOfType(this.getTransaction(), kType.getType(), new String[0]);
        KomodoObject child = null;
        for (KomodoObject kObj : children) {
            if (!kObj.getName(this.getTransaction()).equals(objName)) continue;
            child = kObj;
            break;
        }
        if (child != null) {
            return I18n.bind((String)WorkspaceCommandsI18n.cannotImportWouldCreateDuplicate, (Object[])new Object[]{objName, kType.getType()});
        }
        return "OK";
    }

    protected int getMaxArgCount() {
        return 1;
    }
}

