/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;
import org.teiid.modeshape.sequencer.dataservice.Connection;
import org.teiid.modeshape.sequencer.dataservice.ConnectionReader;

public final class UploadConnectionCommand
extends WorkspaceShellCommand {
    static final String NAME = "upload-connection";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public UploadConnectionCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            boolean overwrite;
            String fileName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingInputConnectionFilePath, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(1, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            String validationResult = this.validateReadableFileArg(fileName);
            if (!"OK".equals(validationResult)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            Repository.UnitOfWork uow = this.getTransaction();
            File connectionFile = new File(fileName);
            ConnectionReader reader = new ConnectionReader();
            Connection connection = reader.read((InputStream)new FileInputStream(connectionFile));
            boolean hasConnection = this.getWorkspaceManager(uow).hasChild(uow, connection.getName(), "dv:connection");
            if (hasConnection && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.connectionOverwriteDisabled, (Object[])new Object[]{fileName, connection.getName()}), null);
            }
            if (hasConnection && overwrite) {
                this.getWorkspaceManager(uow).removeChild(uow, new String[]{connection.getName()});
            }
            org.komodo.relational.connection.Connection ds = this.getWorkspaceManager(uow).createConnection(uow, null, connection.getName());
            KomodoObject fileNode = ds.addChild(uow, "jcr:content", "nt:resource");
            byte[] content = Files.readAllBytes(Paths.get(fileName, new String[0]));
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            fileNode.setProperty(uow, "jcr:data", new Object[]{stream});
            return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.connectionUploaded, (Object[])new Object[]{connection.getName()}));
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadConnectionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadConnectionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadConnectionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

