/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceShellCommand;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;
import org.modeshape.jcr.JcrLexicon;

public final class UploadVdbCommand
extends WorkspaceShellCommand {
    static final String NAME = "upload-vdb";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public UploadVdbCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        try {
            boolean overwrite;
            String vdbName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingVdbNameForUpload, (Object[])new Object[0]));
            String fileName = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingInputVdbFilePath, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(2, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            String validationResult = this.validateReadableFileArg(fileName);
            if (!"OK".equals(validationResult)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
            if (StringUtils.isEmpty((String)content)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.vdbInputFileIsEmpty, (Object[])new Object[]{fileName}), null);
            }
            Repository.UnitOfWork uow = this.getTransaction();
            boolean hasVdb = this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), vdbName, "vdb:virtualDatabase");
            if (hasVdb && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.vdbOverwriteDisabled, (Object[])new Object[]{fileName, vdbName}), null);
            }
            if (hasVdb) {
                KomodoObject vdbToDelete = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), vdbName, "vdb:virtualDatabase");
                this.getWorkspaceManager(this.getTransaction()).delete(this.getTransaction(), new KomodoObject[]{vdbToDelete});
            }
            Vdb vdb = this.getWorkspaceManager(this.getTransaction()).createVdb(uow, null, vdbName, fileName);
            KomodoObject fileNode = vdb.addChild(uow, JcrLexicon.CONTENT.getString(), null);
            fileNode.setProperty(uow, JcrLexicon.DATA.getString(), new Object[]{content});
            return new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.vdbUploaded, (Object[])new Object[]{vdbName}));
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return 3;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)WorkspaceCommandsI18n.uploadVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
        Vdb[] vdbs = mgr.findVdbs(uow);
        ArrayList<String> existingVdbNames = new ArrayList<String>(vdbs.length);
        for (Vdb vdb : vdbs) {
            existingVdbNames.add(vdb.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingVdbNames);
            } else {
                for (String item : existingVdbNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

