/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.runtime.version;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;

public class TestDefaultTeiidVersion {
    @Test
    public void shouldReturnValidVersion() {
        TeiidVersion teiidVersion = DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get();
        System.out.println(teiidVersion);
        Assert.assertNotNull((Object)teiidVersion);
    }

    private TeiidVersion version(String versionId) {
        return new DefaultTeiidVersion(versionId);
    }

    @Test
    public void testCompareTo() {
        Assert.assertTrue((boolean)this.version("8.0.0").compareTo(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").compareTo(this.version("8.0.x")));
        Assert.assertTrue((boolean)this.version("8.0.0").compareTo(this.version("8.x.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").compareTo(this.version("8.x.x")));
        Assert.assertTrue((boolean)this.version("8.0.x").compareTo(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.x.0").compareTo(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.x.x").compareTo(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").compareTo(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").compareTo(this.version("8.1.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").compareTo(this.version("8.x.1")));
        Assert.assertFalse((boolean)this.version("8.0.0").compareTo(this.version("9.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").compareTo(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.1.0").compareTo(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.x.1").compareTo(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("9.0.0").compareTo(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("9.1.1").compareTo(this.version("9.1.x")));
    }

    @Test
    public void testGetMaximum() {
        Assert.assertEquals((Object)this.version("8.0.0"), (Object)this.version("8.0.0").getMaximumVersion());
        Assert.assertEquals((Object)this.version("8.9.0"), (Object)this.version("8.x.0").getMaximumVersion());
        Assert.assertEquals((Object)this.version("8.0.9"), (Object)this.version("8.0.x").getMaximumVersion());
        Assert.assertEquals((Object)this.version("8.9.9"), (Object)this.version("8.x.x").getMaximumVersion());
    }

    @Test
    public void testGetMinimum() {
        Assert.assertEquals((Object)this.version("8.0.0"), (Object)this.version("8.0.0").getMinimumVersion());
        Assert.assertEquals((Object)this.version("8.0.0"), (Object)this.version("8.x.0").getMinimumVersion());
        Assert.assertEquals((Object)this.version("8.0.0"), (Object)this.version("8.0.x").getMinimumVersion());
        Assert.assertEquals((Object)this.version("8.0.0"), (Object)this.version("8.x.x").getMinimumVersion());
    }

    @Test
    public void testIsGreaterThan() {
        Assert.assertFalse((boolean)this.version("8.0.0").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.7.0")));
        Assert.assertFalse((boolean)this.version("7.7.0").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.0.1")));
        Assert.assertFalse((boolean)this.version("7.0.1").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.0.x")));
        Assert.assertFalse((boolean)this.version("7.0.x").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.x.0")));
        Assert.assertFalse((boolean)this.version("7.x.0").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isGreaterThan(this.version("7.x.x")));
        Assert.assertFalse((boolean)this.version("7.x.x").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.x.0").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.x.0")));
        Assert.assertTrue((boolean)this.version("8.0.x").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.0.x")));
        Assert.assertTrue((boolean)this.version("8.x.x").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.x.x")));
        Assert.assertTrue((boolean)this.version("8.0.x").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.0.x")));
        Assert.assertTrue((boolean)this.version("8.x.0").isGreaterThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("7.0.0").isGreaterThan(this.version("8.x.0")));
        Assert.assertFalse((boolean)this.version("8.0.x").isGreaterThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isGreaterThan(this.version("8.0.x")));
        Assert.assertFalse((boolean)this.version("8.x.0").isGreaterThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isGreaterThan(this.version("8.x.0")));
        Assert.assertTrue((boolean)this.version("8.1.extendedmicroversionid").isGreaterThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.designer-2.0").isGreaterThan(this.version("8.designer-1.0")));
        Assert.assertTrue((boolean)this.version("8.designer-10.0").isGreaterThan(this.version("8.designer-1.0")));
        Assert.assertTrue((boolean)this.version("8.teiidteiid-18.0").isGreaterThan(this.version("8.designer-20.0")));
        Assert.assertFalse((boolean)this.version("8.designer-20.0").isGreaterThan(this.version("8.teiidteiid-18.0")));
        Assert.assertTrue((boolean)this.version("8.11.0").isGreaterThan(this.version("8.8.0")));
        Assert.assertTrue((boolean)this.version("8.10.0").isGreaterThan(this.version("8.8.0")));
        Assert.assertTrue((boolean)this.version("8.10.1").isGreaterThan(this.version("8.10.0")));
        Assert.assertFalse((boolean)this.version("8.10.1").isGreaterThan(this.version("8.11.0")));
        Assert.assertFalse((boolean)this.version("8.7.1").isGreaterThan(this.version("8.7.x")));
        Assert.assertTrue((boolean)this.version("8.12.4").isGreaterThan(this.version("8.9.0")));
    }

    @Test
    public void testIsLessThan() {
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.0.0")));
        Assert.assertTrue((boolean)this.version("7.7.0").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.7.0")));
        Assert.assertTrue((boolean)this.version("7.0.1").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.0.1")));
        Assert.assertTrue((boolean)this.version("7.0.x").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.0.x")));
        Assert.assertTrue((boolean)this.version("7.x.0").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.x.0")));
        Assert.assertTrue((boolean)this.version("7.x.x").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("7.x.x")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.x.0")));
        Assert.assertFalse((boolean)this.version("8.x.0").isLessThan(this.version("7.0.0")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.0.x")));
        Assert.assertFalse((boolean)this.version("8.0.x").isLessThan(this.version("7.0.0")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.x.x")));
        Assert.assertFalse((boolean)this.version("8.x.x").isLessThan(this.version("7.0.0")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.0.x")));
        Assert.assertFalse((boolean)this.version("8.0.x").isLessThan(this.version("7.0.0")));
        Assert.assertTrue((boolean)this.version("7.0.0").isLessThan(this.version("8.x.0")));
        Assert.assertFalse((boolean)this.version("8.x.0").isLessThan(this.version("7.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("8.0.x")));
        Assert.assertFalse((boolean)this.version("8.0.x").isLessThan(this.version("8.0.0")));
        Assert.assertFalse((boolean)this.version("8.0.0").isLessThan(this.version("8.x.0")));
        Assert.assertFalse((boolean)this.version("8.x.0").isLessThan(this.version("8.0.0")));
        Assert.assertTrue((boolean)this.version("8.0.0").isLessThan(this.version("8.1.extendedmicroversionid")));
        Assert.assertTrue((boolean)this.version("8.designer-1.0").isLessThan(this.version("8.designer-2.0")));
        Assert.assertTrue((boolean)this.version("8.designer-1.0").isLessThan(this.version("8.designer-10.0")));
        Assert.assertTrue((boolean)this.version("8.designer-20.0").isLessThan(this.version("8.teiidteiid-18.0")));
        Assert.assertFalse((boolean)this.version("8.teiidteiid-18.0").isLessThan(this.version("8.designer-20.0")));
        Assert.assertTrue((boolean)this.version("8.7.0").isLessThan(this.version("8.7.1")));
        Assert.assertTrue((boolean)this.version("8.8.0").isLessThan(this.version("8.10.0")));
        Assert.assertFalse((boolean)this.version("8.7.1").isLessThan(this.version("8.7.x")));
    }

    @Test
    public void testIsLessThan2() {
        Assert.assertTrue((boolean)DefaultTeiidVersion.Version.TEIID_8_12_4.get().isLessThan(this.version("9.0.0")));
        Assert.assertFalse((boolean)DefaultTeiidVersion.Version.TEIID_8_12_4.get().isLessThan(this.version("8.6.0")));
    }
}

