/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.komodo.spi.constants.StringConstants;

public class Messages
implements StringConstants {
    private static final String BUNDLE_NAME = Messages.class.getPackage().getName() + "." + Messages.class.getSimpleName().toLowerCase();
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    private static String getEnumName(Enum<?> enumValue) {
        String className = enumValue.getClass().getName();
        String[] components = className.split("\\$");
        return components[components.length - 1];
    }

    private Messages() {
    }

    private static String getString(Enum<?> key) {
        try {
            return RESOURCE_BUNDLE.getString(key.toString());
        }
        catch (Exception err) {
            String msg = err instanceof NullPointerException ? "<No message available>" : (err instanceof MissingResourceException ? "<Missing message for key \"" + key + "\" in: " + BUNDLE_NAME + ">" : err.getLocalizedMessage());
            return msg;
        }
    }

    public static String getString(Enum<?> key, Object ... parameters) {
        String text = Messages.getString(key);
        if (text == null) {
            return "<" + key.toString() + ">";
        }
        if (parameters == null || parameters.length == 0) {
            return text;
        }
        return MessageFormat.format(text, parameters);
    }

    public static enum OutcomeFactory {
        OK;


        public String toString() {
            return Messages.getEnumName(this) + "." + this.name();
        }
    }

    public static enum SPI {
        valueCannotBeEmpty,
        valueCannotBeNull,
        invalidTargetTypeForGetTeiidMethod,
        invalidTargetTypeForGetDataSourceMethod,
        invalidTargetTypeForGetTranslatorMethod,
        invalidTargetTypeForGetUpdatedTeiidMethod;


        public String toString() {
            return Messages.getEnumName(this) + "." + this.name();
        }
    }
}

