/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import org.komodo.spi.annotation.Removed;
import org.komodo.spi.annotation.Since;
import org.komodo.spi.annotation.Updated;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static boolean hasAnnotation(Class<?> klazz, Class<? extends Annotation> annotationClass) {
        return klazz.isAnnotationPresent(annotationClass);
    }

    public static boolean hasAnnotation(AccessibleObject accessibleObject, Class<? extends Annotation> annotationClass) {
        return accessibleObject.isAnnotationPresent(annotationClass);
    }

    public static boolean hasAnnotation(Enum<?> enumValue, Class<? extends Annotation> annotationClass) {
        try {
            Field enumField = enumValue.getClass().getField(enumValue.name());
            return AnnotationUtils.hasAnnotation(enumField, annotationClass);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> klazz, Class<T> annotationClass) {
        return klazz.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(AccessibleObject accessibleObject, Class<T> annotationClass) {
        return accessibleObject.getAnnotation(annotationClass);
    }

    public static DefaultTeiidVersion.Version getSinceVersion(AccessibleObject accessibleObject, Class<Since> since) {
        Since sinceAnnotation = AnnotationUtils.getAnnotation(accessibleObject, since);
        if (sinceAnnotation == null) {
            return null;
        }
        return sinceAnnotation.value();
    }

    public static DefaultTeiidVersion.Version getRemovedVersion(AccessibleObject accessibleObject, Class<Removed> removed) {
        Removed removedAnnotation = AnnotationUtils.getAnnotation(accessibleObject, removed);
        if (removedAnnotation == null) {
            return null;
        }
        return removedAnnotation.value();
    }

    public static <T extends Annotation> T getAnnotation(Enum<?> enumValue, Class<T> annotationClass) {
        try {
            Field enumField = enumValue.getClass().getField(enumValue.name());
            return AnnotationUtils.getAnnotation(enumField, annotationClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isGreaterOrEqualThan(TeiidVersion testVersion, TeiidVersion currentVersion) {
        return (currentVersion = currentVersion.getMinimumVersion()).equals(testVersion) || currentVersion.isGreaterThan(testVersion);
    }

    public static boolean isGreaterThanOrEqualTo(Removed removed, TeiidVersion currentVersion) {
        if (removed == null || currentVersion == null) {
            return false;
        }
        return AnnotationUtils.isGreaterOrEqualThan(removed.value().get(), currentVersion);
    }

    public static boolean isGreaterThanOrEqualTo(Since since, TeiidVersion currentVersion) {
        if (since == null || currentVersion == null) {
            return true;
        }
        return AnnotationUtils.isGreaterOrEqualThan(since.value().get(), currentVersion);
    }

    public static boolean isApplicable(Class<?> obj, TeiidVersion currentVersion) {
        Since since;
        Removed removed;
        if (AnnotationUtils.hasAnnotation(obj, Removed.class) && AnnotationUtils.isGreaterThanOrEqualTo(removed = AnnotationUtils.getAnnotation(obj, Removed.class), currentVersion)) {
            return false;
        }
        return !AnnotationUtils.hasAnnotation(obj, Since.class) || AnnotationUtils.isGreaterThanOrEqualTo(since = AnnotationUtils.getAnnotation(obj, Since.class), currentVersion);
    }

    public static boolean isApplicable(AccessibleObject obj, TeiidVersion currentVersion) {
        Since since;
        Removed removed;
        if (AnnotationUtils.hasAnnotation(obj, Removed.class) && AnnotationUtils.isGreaterThanOrEqualTo(removed = AnnotationUtils.getAnnotation(obj, Removed.class), currentVersion)) {
            return false;
        }
        return !AnnotationUtils.hasAnnotation(obj, Since.class) || AnnotationUtils.isGreaterThanOrEqualTo(since = AnnotationUtils.getAnnotation(obj, Since.class), currentVersion);
    }

    public static boolean isApplicable(Enum<?> obj, TeiidVersion currentVersion) {
        try {
            Removed removed;
            if (AnnotationUtils.hasAnnotation(obj, Removed.class) && AnnotationUtils.isGreaterThanOrEqualTo(removed = AnnotationUtils.getAnnotation(obj, Removed.class), currentVersion)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        try {
            Since since;
            if (AnnotationUtils.hasAnnotation(obj, Since.class) && !AnnotationUtils.isGreaterThanOrEqualTo(since = AnnotationUtils.getAnnotation(obj, Since.class), currentVersion)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String getUpdatedName(Enum<?> enumValue, String updatedName, TeiidVersion currentVersion) {
        if (!AnnotationUtils.hasAnnotation(enumValue, Updated.class)) {
            return updatedName;
        }
        Updated updated = AnnotationUtils.getAnnotation(enumValue, Updated.class);
        DefaultTeiidVersion.Version[] versions = updated.version();
        String[] replacements = updated.replaces();
        ArrayList<UpdateVersionPair> pairs = new ArrayList<UpdateVersionPair>();
        for (int i = 0; i < versions.length; ++i) {
            DefaultTeiidVersion.Version version = versions[i];
            if (i >= replacements.length) break;
            String replaced = replacements[i];
            pairs.add(new UpdateVersionPair(version.get(), replaced));
        }
        Collections.sort(pairs);
        UpdateVersionPair maxPair = (UpdateVersionPair)pairs.get(pairs.size() - 1);
        if (currentVersion.isGreaterThanOrEqualTo(maxPair.getVersion())) {
            return updatedName;
        }
        UpdateVersionPair rangePair = null;
        for (UpdateVersionPair pair : pairs) {
            if (rangePair == null) {
                rangePair = pair;
                continue;
            }
            if (!currentVersion.isLessThan(pair.getVersion()) && !currentVersion.equals((rangePair = pair).getVersion())) continue;
            break;
        }
        return rangePair.getReplacedValue();
    }

    private static class UpdateVersionPair
    implements Comparable<UpdateVersionPair> {
        private final TeiidVersion version;
        private final String replacedValue;

        public UpdateVersionPair(TeiidVersion version, String replacedValue) {
            this.version = version;
            this.replacedValue = replacedValue;
        }

        public TeiidVersion getVersion() {
            return this.version;
        }

        public String getReplacedValue() {
            return this.replacedValue;
        }

        @Override
        public int compareTo(UpdateVersionPair other) {
            if (this.getVersion().equals(other.getVersion())) {
                return 0;
            }
            if (this.getVersion().isLessThan(other.getVersion())) {
                return -1;
            }
            return 1;
        }
    }
}

