/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.lexicon;

import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;

public class TeiidSqlLexicon
implements StringConstants {

    public static enum LexTokens {
        EXPRESSION_STATEMENT("tsql:expressionStatement", ExpressionStatement.class),
        LANGUAGE_OBJECT("tsql:languageObject", LanguageObject.class),
        EXPRESSION("tsql:expression", Expression.class),
        PREDICATE_CRITERIA("tsql:predicateCriteria", PredicateCriteria.class),
        SUBQUERY_CONTAINER("tsql:subqueryContainer", SubqueryContainer.class),
        TARGETED_COMMAND("tsql:targetedCommand", TargetedCommand.class),
        LABELED("tsql:labeled", Labeled.class),
        CRITERIA("tsql:criteria", Criteria.class),
        ABSTRACT_COMPARE_CRITERIA("tsql:abstractCompareCriteria", AbstractCompareCriteria.class),
        COMPARE_CRITERIA("tsql:compareCriteria", CompareCriteria.class),
        SUBQUERY_COMPARE_CRITERIA("tsql:subqueryCompareCriteria", SubqueryCompareCriteria.class),
        ABSTRACT_SET_CRITERIA("tsql:abstractSetCriteria", AbstractSetCriteria.class),
        SET_CRITERIA("tsql:setCriteria", SetCriteria.class),
        SUBQUERY_SET_CRITERIA("tsql:subquerySetCriteria", SubquerySetCriteria.class),
        BETWEEN_CRITERIA("tsql:betweenCriteria", BetweenCriteria.class),
        COMPOUND_CRITERIA("tsql:compoundCriteria", CompoundCriteria.class),
        EXISTS_CRITERIA("tsql:existsCriteria", ExistsCriteria.class),
        EXPRESSION_CRITERIA("tsql:expressionCriteria", ExpressionCriteria.class),
        IS_NULL_CRITERIA("tsql:isNullCriteria", IsNullCriteria.class),
        MATCH_CRITERIA("tsql:matchCriteria", MatchCriteria.class),
        NOT_CRITERIA("tsql:notCriteria", NotCriteria.class),
        COMMAND("tsql:command", Command.class),
        ALTER("tsql:alter", Alter.class),
        ALTER_PROCEDURE("tsql:alterProcedure", AlterProcedure.class),
        ALTER_TRIGGER("tsql:alterTrigger", AlterTrigger.class),
        ALTER_VIEW("tsql:alterView", AlterView.class),
        PROCEDURE_CONTAINER("tsql:procedureContainer", ProcedureContainer.class),
        DELETE("tsql:delete", Delete.class),
        INSERT("tsql:insert", Insert.class),
        STORED_PROCEDURE("tsql:storedProcedure", StoredProcedure.class),
        UPDATE("tsql:update", Update.class),
        DYNAMIC_COMMAND("tsql:dynamicCommand", DynamicCommand.class),
        QUERY_COMMAND("tsql:queryCommand", QueryCommand.class),
        QUERY("tsql:query", Query.class),
        SET_QUERY("tsql:setQuery", SetQuery.class),
        CREATE_PROCEDURE_COMMAND("tsql:createProcedureCommand", CreateProcedureCommand.class),
        TRIGGER_ACTION("tsql:triggerAction", TriggerAction.class),
        FROM_CLAUSE("tsql:fromClause", FromClause.class),
        TABLE_FUNCTION_REFERENCE("tsql:tableFunctionReference", TableFunctionReference.class),
        ARRAY_TABLE("tsql:arrayTable", ArrayTable.class),
        OBJECT_TABLE("tsql:objectTable", ObjectTable.class),
        TEXT_TABLE("tsql:textTable", TextTable.class),
        XML_TABLE("tsql:xmlTable", XMLTable.class),
        JOIN_PREDICATE("tsql:joinPredicate", JoinPredicate.class),
        SUBQUERY_FROM_CLAUSE("tsql:subqueryFromClause", SubqueryFromClause.class),
        UNARY_FROM_CLAUSE("tsql:unaryFromClause", UnaryFromClause.class),
        FROM("tsql:from", From.class),
        GROUP_BY("tsql:groupBy", GroupBy.class),
        INTO("tsql:into", Into.class),
        JOIN_TYPE("tsql:joinType", JoinType.class),
        LIMIT("tsql:limit", Limit.class),
        MAKE_DEP("tsql:makeDep", MakeDep.class),
        NAMESPACE_ITEM("tsql:namespaceItem", NamespaceItem.class),
        NULL_NODE("tsql:nullNode", NullNode.class),
        PROJECTED_COLUMN("tsql:projectedColumn", ProjectedColumn.class),
        OBJECT_COLUMN("tsql:objectColumn", ObjectColumn.class),
        TEXT_COLUMN("tsql:textColumn", TextColumn.class),
        XML_COLUMN("tsql:xmlColumn", XMLColumn.class),
        OPTION("tsql:option", Option.class),
        ORDER_BY("tsql:orderBy", OrderBy.class),
        ORDER_BY_ITEM("tsql:orderByItem", OrderByItem.class),
        SP_PARAMETER("tsql:spParameter", SPParameter.class),
        SELECT("tsql:select", Select.class),
        SET_CLAUSE("tsql:setClause", SetClause.class),
        SET_CLAUSE_LIST("tsql:setClauseList", SetClauseList.class),
        SOURCE_HINT("tsql:sourceHint", SourceHint.class),
        SPECIFIC_HINT("tsql:specificHint", SpecificHint.class),
        SUBQUERY_HINT("tsql:subqueryHint", SubqueryHint.class),
        WITH_QUERY_COMMAND("tsql:withQueryCommand", WithQueryCommand.class),
        STATEMENT("tsql:statement", Statement.class),
        ASSIGNMENT_STATEMENT("tsql:assignmentStatement", AssignmentStatement.class),
        DECLARE_STATEMENT("tsql:declareStatement", DeclareStatement.class),
        RETURN_STATEMENT("tsql:returnStatement", ReturnStatement.class),
        BLOCK("tsql:block", Block.class),
        BRANCHING_STATEMENT("tsql:branchingStatement", BranchingStatement.class),
        COMMAND_STATEMENT("tsql:commandStatement", CommandStatement.class),
        IF_STATEMENT("tsql:ifStatement", IfStatement.class),
        LOOP_STATEMENT("tsql:loopStatement", LoopStatement.class),
        RAISE_STATEMENT("tsql:raiseStatement", RaiseStatement.class),
        WHILE_STATEMENT("tsql:whileStatement", WhileStatement.class),
        EXCEPTION_EXPRESSION("tsql:exceptionExpression", ExceptionExpression.class),
        FUNCTION("tsql:function", Function.class),
        AGGREGATE_SYMBOL("tsql:aggregateSymbol", AggregateSymbol.class),
        SYMBOL("tsql:symbol", Symbol.class),
        ALIAS_SYMBOL("tsql:aliasSymbol", AliasSymbol.class),
        ELEMENT_SYMBOL("tsql:elementSymbol", ElementSymbol.class),
        EXPRESSION_SYMBOL("tsql:expressionSymbol", ExpressionSymbol.class),
        GROUP_SYMBOL("tsql:groupSymbol", GroupSymbol.class),
        ARRAY_SYMBOL("tsql:arraySymbol", ArraySymbol.class),
        CASE_EXPRESSION("tsql:caseExpression", CaseExpression.class),
        CONSTANT("tsql:constant", Constant.class),
        DERIVED_COLUMN("tsql:derivedColumn", DerivedColumn.class),
        JSON_OBJECT("tsql:jsonObject", JSONObject.class),
        MULTIPLE_ELEMENT_SYMBOL("tsql:multipleElementSymbol", MultipleElementSymbol.class),
        QUERY_STRING("tsql:queryString", QueryString.class),
        REFERENCE("tsql:reference", Reference.class),
        SCALAR_SUBQUERY("tsql:scalarSubquery", ScalarSubquery.class),
        SEARCHED_CASE_EXPRESSION("tsql:searchedCaseExpression", SearchedCaseExpression.class),
        TEXT_LINE("tsql:textLine", TextLine.class),
        WINDOW_FUNCTION("tsql:windowFunction", WindowFunction.class),
        WINDOW_SPECIFICATION("tsql:windowSpecification", WindowSpecification.class),
        XML_ATTRIBUTES("tsql:xmlAttributes", XMLAttributes.class),
        XML_CAST("tsql:xmlCast", XMLCast.class),
        XML_ELEMENT("tsql:xmlElement", XMLElement.class),
        XML_EXISTS("tsql:xmlExists", XMLExists.class),
        XML_FOREST("tsql:xmlForest", XMLForest.class),
        XML_NAMESPACES("tsql:xmlNamespaces", XMLNamespaces.class),
        XML_PARSE("tsql:xmlParse", XMLParse.class),
        XML_QUERY("tsql:xmlQuery", XMLQuery.class),
        XML_SERIALIZE("tsql:xmlSerialize", XMLSerialize.class),
        CACHE_HINT("tsql:cacheHint", CacheHint.class),
        IS_DISTINCT_CRITERIA("tsql:isDistinctCriteria", IsDistinctCriteria.class);

        private String id;
        private Class<?> klazz;

        private LexTokens(String id, Class<?> klazz) {
            this.id = id;
            this.klazz = klazz;
        }

        public String getId() {
            return this.id;
        }

        public Class<?> getTSqlClass() {
            return this.klazz;
        }

        public static LexTokens findClass(String id) {
            for (LexTokens tSqlClass : LexTokens.values()) {
                if (!tSqlClass.getId().equals(id)) continue;
                return tSqlClass;
            }
            return null;
        }
    }

    public static interface XMLSerialize
    extends Expression {
        public static final String ID = "tsql:xmlSerialize";
        public static final boolean IS_ABSTRACT = false;
        public static final String DOCUMENT_PROP_NAME = "tsql:document";
        public static final Class<?> DOCUMENT_PROP_TYPE = Boolean.class;
        public static final boolean DOCUMENT_PROP_MULTIPLE = false;
        public static final String ENCODING_PROP_NAME = "tsql:encoding";
        public static final Class<?> ENCODING_PROP_TYPE = String.class;
        public static final boolean ENCODING_PROP_MULTIPLE = false;
        public static final String TYPE_STRING_PROP_NAME = "tsql:typeString";
        public static final Class<?> TYPE_STRING_PROP_TYPE = String.class;
        public static final boolean TYPE_STRING_PROP_MULTIPLE = false;
        public static final String VERSION_PROP_NAME = "tsql:version";
        public static final Class<?> VERSION_PROP_TYPE = String.class;
        public static final boolean VERSION_PROP_MULTIPLE = false;
        public static final String DECLARATION_PROP_NAME = "tsql:declaration";
        public static final Class<?> DECLARATION_PROP_TYPE = Boolean.class;
        public static final boolean DECLARATION_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface XMLQuery
    extends Expression {
        public static final String ID = "tsql:xmlQuery";
        public static final boolean IS_ABSTRACT = false;
        public static final String XQUERY_PROP_NAME = "tsql:xquery";
        public static final Class<?> XQUERY_PROP_TYPE = String.class;
        public static final boolean XQUERY_PROP_MULTIPLE = false;
        public static final String EMPTY_ON_EMPTY_PROP_NAME = "tsql:emptyOnEmpty";
        public static final Class<?> EMPTY_ON_EMPTY_PROP_TYPE = Boolean.class;
        public static final boolean EMPTY_ON_EMPTY_PROP_MULTIPLE = false;
        public static final String NAMESPACES_REF_NAME = "tsql:namespaces";
        public static final Class<?> NAMESPACES_REF_TYPE = XMLNamespaces.class;
        public static final boolean NAMESPACES_REF_MULTIPLE = false;
        public static final String PASSING_REF_NAME = "tsql:passing";
        public static final Class<?> PASSING_REF_TYPE = DerivedColumn.class;
        public static final boolean PASSING_REF_MULTIPLE = true;
    }

    public static interface XMLParse
    extends Expression {
        public static final String ID = "tsql:xmlParse";
        public static final boolean IS_ABSTRACT = false;
        public static final String DOCUMENT_PROP_NAME = "tsql:document";
        public static final Class<?> DOCUMENT_PROP_TYPE = Boolean.class;
        public static final boolean DOCUMENT_PROP_MULTIPLE = false;
        public static final String WELL_FORMED_PROP_NAME = "tsql:wellFormed";
        public static final Class<?> WELL_FORMED_PROP_TYPE = Boolean.class;
        public static final boolean WELL_FORMED_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface XMLNamespaces
    extends LanguageObject {
        public static final String ID = "tsql:xmlNamespaces";
        public static final boolean IS_ABSTRACT = false;
        public static final String NO_DEFAULT = "NO DEFAULT";
        public static final String NAMESPACE_ITEMS_REF_NAME = "tsql:namespaceItems";
        public static final Class<?> NAMESPACE_ITEMS_REF_TYPE = NamespaceItem.class;
        public static final boolean NAMESPACE_ITEMS_REF_MULTIPLE = true;
    }

    public static interface XMLForest
    extends Expression {
        public static final String ID = "tsql:xmlForest";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAMESPACES_REF_NAME = "tsql:namespaces";
        public static final Class<?> NAMESPACES_REF_TYPE = XMLNamespaces.class;
        public static final boolean NAMESPACES_REF_MULTIPLE = false;
        public static final String ARGUMENTS_REF_NAME = "tsql:arguments";
        public static final Class<?> ARGUMENTS_REF_TYPE = DerivedColumn.class;
        public static final boolean ARGUMENTS_REF_MULTIPLE = true;
    }

    public static interface XMLExists
    extends Criteria {
        public static final String ID = "tsql:xmlExists";
        public static final boolean IS_ABSTRACT = false;
        public static final String XML_QUERY_REF_NAME = "tsql:xmlQuery";
        public static final Class<?> XML_QUERY_REF_TYPE = XMLQuery.class;
        public static final boolean XML_QUERY_REF_MULTIPLE = false;
    }

    public static interface XMLElement
    extends Expression {
        public static final String ID = "tsql:xmlElement";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String CONTENT_REF_NAME = "tsql:content";
        public static final Class<?> CONTENT_REF_TYPE = Expression.class;
        public static final boolean CONTENT_REF_MULTIPLE = true;
        public static final String NAMESPACES_REF_NAME = "tsql:namespaces";
        public static final Class<?> NAMESPACES_REF_TYPE = XMLNamespaces.class;
        public static final boolean NAMESPACES_REF_MULTIPLE = false;
        public static final String ATTRIBUTES_REF_NAME = "tsql:attributes";
        public static final Class<?> ATTRIBUTES_REF_TYPE = XMLAttributes.class;
        public static final boolean ATTRIBUTES_REF_MULTIPLE = false;
    }

    public static interface XMLCast
    extends Expression {
        public static final String ID = "tsql:xmlCast";
        public static final boolean IS_ABSTRACT = false;
        public static final String EXPRESSION_PROP_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_PROP_TYPE = Expression.class;
        public static final boolean EXPRESSION_PROP_MULTIPLE = false;
    }

    public static interface XMLAttributes
    extends LanguageObject {
        public static final String ID = "tsql:xmlAttributes";
        public static final boolean IS_ABSTRACT = false;
        public static final String ARGS_REF_NAME = "tsql:args";
        public static final Class<?> ARGS_REF_TYPE = DerivedColumn.class;
        public static final boolean ARGS_REF_MULTIPLE = true;
    }

    public static interface WindowSpecification
    extends LanguageObject {
        public static final String ID = "tsql:windowSpecification";
        public static final boolean IS_ABSTRACT = false;
        public static final String PARTITION_REF_NAME = "tsql:partition";
        public static final Class<?> PARTITION_REF_TYPE = Expression.class;
        public static final boolean PARTITION_REF_MULTIPLE = true;
        public static final String ORDER_BY_REF_NAME = "tsql:orderBy";
        public static final Class<?> ORDER_BY_REF_TYPE = OrderBy.class;
        public static final boolean ORDER_BY_REF_MULTIPLE = false;
    }

    public static interface WindowFunction
    extends Expression {
        public static final String ID = "tsql:windowFunction";
        public static final boolean IS_ABSTRACT = false;
        public static final String FUNCTION_REF_NAME = "tsql:function";
        public static final Class<?> FUNCTION_REF_TYPE = AggregateSymbol.class;
        public static final boolean FUNCTION_REF_MULTIPLE = false;
        public static final String WINDOW_SPECIFICATION_REF_NAME = "tsql:windowSpecification";
        public static final Class<?> WINDOW_SPECIFICATION_REF_TYPE = WindowSpecification.class;
        public static final boolean WINDOW_SPECIFICATION_REF_MULTIPLE = false;
    }

    public static interface TextLine
    extends Expression {
        public static final String ID = "tsql:textLine";
        public static final boolean IS_ABSTRACT = false;
        public static final String QUOTE_PROP_NAME = "tsql:quote";
        public static final Class<?> QUOTE_PROP_TYPE = String.class;
        public static final boolean QUOTE_PROP_MULTIPLE = false;
        public static final String INCLUDE_HEADER_PROP_NAME = "tsql:includeHeader";
        public static final Class<?> INCLUDE_HEADER_PROP_TYPE = Boolean.class;
        public static final boolean INCLUDE_HEADER_PROP_MULTIPLE = false;
        public static final String ENCODING_PROP_NAME = "tsql:encoding";
        public static final Class<?> ENCODING_PROP_TYPE = String.class;
        public static final boolean ENCODING_PROP_MULTIPLE = false;
        public static final String DELIMITER_PROP_NAME = "tsql:delimiter";
        public static final Class<?> DELIMITER_PROP_TYPE = String.class;
        public static final boolean DELIMITER_PROP_MULTIPLE = false;
        public static final String EXPRESSIONS_REF_NAME = "tsql:expressions";
        public static final Class<?> EXPRESSIONS_REF_TYPE = DerivedColumn.class;
        public static final boolean EXPRESSIONS_REF_MULTIPLE = true;
    }

    public static interface SearchedCaseExpression
    extends Expression {
        public static final String ID = "tsql:searchedCaseExpression";
        public static final boolean IS_ABSTRACT = false;
        public static final String ELSE_EXPRESSION_REF_NAME = "tsql:elseExpression";
        public static final Class<?> ELSE_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean ELSE_EXPRESSION_REF_MULTIPLE = false;
        public static final String WHEN_REF_NAME = "tsql:when";
        public static final Class<?> WHEN_REF_TYPE = Criteria.class;
        public static final boolean WHEN_REF_MULTIPLE = true;
        public static final String THEN_REF_NAME = "tsql:then";
        public static final Class<?> THEN_REF_TYPE = Expression.class;
        public static final boolean THEN_REF_MULTIPLE = true;
    }

    public static interface ScalarSubquery
    extends Expression,
    SubqueryContainer {
        public static final String ID = "tsql:scalarSubquery";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface Reference
    extends Expression {
        public static final String ID = "tsql:reference";
        public static final boolean IS_ABSTRACT = false;
        public static final String POSITIONAL_PROP_NAME = "tsql:positional";
        public static final Class<?> POSITIONAL_PROP_TYPE = Boolean.class;
        public static final boolean POSITIONAL_PROP_MULTIPLE = false;
        public static final String INDEX_PROP_NAME = "tsql:index";
        public static final Class<?> INDEX_PROP_TYPE = Long.class;
        public static final boolean INDEX_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = ElementSymbol.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface QueryString
    extends Expression {
        public static final String ID = "tsql:queryString";
        public static final boolean IS_ABSTRACT = false;
        public static final String ARGS_REF_NAME = "tsql:args";
        public static final Class<?> ARGS_REF_TYPE = DerivedColumn.class;
        public static final boolean ARGS_REF_MULTIPLE = true;
        public static final String PATH_REF_NAME = "tsql:path";
        public static final Class<?> PATH_REF_TYPE = Expression.class;
        public static final boolean PATH_REF_MULTIPLE = false;
    }

    public static interface MultipleElementSymbol
    extends Expression {
        public static final String ID = "tsql:multipleElementSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String GROUP_REF_NAME = "tsql:group";
        public static final Class<?> GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_REF_MULTIPLE = false;
        public static final String ELEMENT_SYMBOLS_REF_NAME = "tsql:elementSymbols";
        public static final Class<?> ELEMENT_SYMBOLS_REF_TYPE = ElementSymbol.class;
        public static final boolean ELEMENT_SYMBOLS_REF_MULTIPLE = true;
    }

    public static interface JSONObject
    extends Expression {
        public static final String ID = "tsql:jsonObject";
        public static final boolean IS_ABSTRACT = false;
        public static final String ARGS_REF_NAME = "tsql:args";
        public static final Class<?> ARGS_REF_TYPE = DerivedColumn.class;
        public static final boolean ARGS_REF_MULTIPLE = true;
    }

    public static interface DerivedColumn
    extends LanguageObject {
        public static final String ID = "tsql:derivedColumn";
        public static final boolean IS_ABSTRACT = false;
        public static final String ALIAS_PROP_NAME = "tsql:alias";
        public static final Class<?> ALIAS_PROP_TYPE = String.class;
        public static final boolean ALIAS_PROP_MULTIPLE = false;
        public static final String PROPAGATE_NAME_PROP_NAME = "tsql:propagateName";
        public static final Class<?> PROPAGATE_NAME_PROP_TYPE = Boolean.class;
        public static final boolean PROPAGATE_NAME_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface Constant
    extends Expression {
        public static final String ID = "tsql:constant";
        public static final boolean IS_ABSTRACT = false;
        public static final String MULTI_VALUED_PROP_NAME = "tsql:multiValued";
        public static final Class<?> MULTI_VALUED_PROP_TYPE = Boolean.class;
        public static final boolean MULTI_VALUED_PROP_MULTIPLE = false;
        public static final String VALUE_PROP_NAME = "tsql:value";
        public static final Class<?> VALUE_PROP_TYPE = String.class;
        public static final boolean VALUE_PROP_MULTIPLE = false;
    }

    public static interface CaseExpression
    extends Expression {
        public static final String ID = "tsql:caseExpression";
        public static final boolean IS_ABSTRACT = false;
        public static final String ELSE_EXPRESSION_REF_NAME = "tsql:elseExpression";
        public static final Class<?> ELSE_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean ELSE_EXPRESSION_REF_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
        public static final String WHEN_REF_NAME = "tsql:when";
        public static final Class<?> WHEN_REF_TYPE = Expression.class;
        public static final boolean WHEN_REF_MULTIPLE = true;
        public static final String THEN_REF_NAME = "tsql:then";
        public static final Class<?> THEN_REF_TYPE = Expression.class;
        public static final boolean THEN_REF_MULTIPLE = true;
    }

    public static interface ArraySymbol
    extends Expression {
        public static final String ID = "tsql:arraySymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String IMPLICIT_PROP_NAME = "tsql:implicit";
        public static final Class<?> IMPLICIT_PROP_TYPE = Boolean.class;
        public static final boolean IMPLICIT_PROP_MULTIPLE = false;
        public static final String EXPRESSIONS_REF_NAME = "tsql:expressions";
        public static final Class<?> EXPRESSIONS_REF_TYPE = Expression.class;
        public static final boolean EXPRESSIONS_REF_MULTIPLE = true;
    }

    public static interface GroupSymbol
    extends Symbol {
        public static final String ID = "tsql:groupSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String PROCEDURE_PROP_NAME = "tsql:procedure";
        public static final Class<?> PROCEDURE_PROP_TYPE = Boolean.class;
        public static final boolean PROCEDURE_PROP_MULTIPLE = false;
        public static final String DEFINITION_PROP_NAME = "tsql:definition";
        public static final Class<?> DEFINITION_PROP_TYPE = String.class;
        public static final boolean DEFINITION_PROP_MULTIPLE = false;
        public static final String METADATAID_PROP_NAME = "tsql:metadataiD";
        public static final Class<?> METADATAID_PROP_TYPE = String.class;
        public static final boolean METADATAID_PROP_MULTIPLE = false;
    }

    public static interface ExpressionSymbol
    extends Symbol,
    Expression {
        public static final String ID = "tsql:expressionSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface ElementSymbol
    extends Symbol,
    Expression {
        public static final String ID = "tsql:elementSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String DISPLAY_MODE_PROP_NAME = "tsql:displayMode";
        public static final Class<?> DISPLAY_MODE_PROP_TYPE = String.class;
        public static final boolean DISPLAY_MODE_PROP_MULTIPLE = false;
        public static final String[] DISPLAY_MODE_PROP_CONSTRAINTS = new String[]{"FULLY_QUALIFIED", "OUTPUT_NAME", "SHORT_OUTPUT_NAME"};
        public static final String EXTERNAL_REFERENCE_PROP_NAME = "tsql:externalReference";
        public static final Class<?> EXTERNAL_REFERENCE_PROP_TYPE = Boolean.class;
        public static final boolean EXTERNAL_REFERENCE_PROP_MULTIPLE = false;
        public static final String DISPLAY_FULLY_QUALIFIED_PROP_NAME = "tsql:displayFullyQualified";
        public static final Class<?> DISPLAY_FULLY_QUALIFIED_PROP_TYPE = Boolean.class;
        public static final boolean DISPLAY_FULLY_QUALIFIED_PROP_MULTIPLE = false;
        public static final String METADATAID_PROP_NAME = "tsql:metadataiD";
        public static final Class<?> METADATAID_PROP_TYPE = String.class;
        public static final boolean METADATAID_PROP_MULTIPLE = false;
        public static final String GROUP_SYMBOL_REF_NAME = "tsql:groupSymbol";
        public static final Class<?> GROUP_SYMBOL_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_SYMBOL_REF_MULTIPLE = false;
    }

    public static interface AliasSymbol
    extends Symbol,
    Expression {
        public static final String ID = "tsql:aliasSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String SYMBOL_REF_NAME = "tsql:symbol";
        public static final Class<?> SYMBOL_REF_TYPE = Expression.class;
        public static final boolean SYMBOL_REF_MULTIPLE = false;
    }

    public static interface Symbol
    extends LanguageObject {
        public static final String ID = "tsql:symbol";
        public static final boolean IS_ABSTRACT = true;
        public static final String SEPARATOR = ".";
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String SHORT_NAME_PROP_NAME = "tsql:shortName";
        public static final Class<?> SHORT_NAME_PROP_TYPE = String.class;
        public static final boolean SHORT_NAME_PROP_MULTIPLE = false;
        public static final String OUTPUT_NAME_PROP_NAME = "tsql:outputName";
        public static final Class<?> OUTPUT_NAME_PROP_TYPE = String.class;
        public static final boolean OUTPUT_NAME_PROP_MULTIPLE = false;
    }

    public static interface AggregateSymbol
    extends Function {
        public static final String ID = "tsql:aggregateSymbol";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String AGGREGATE_FUNCTION_PROP_NAME = "tsql:aggregateFunction";
        public static final Class<?> AGGREGATE_FUNCTION_PROP_TYPE = String.class;
        public static final boolean AGGREGATE_FUNCTION_PROP_MULTIPLE = false;
        public static final String WINDOWED_PROP_NAME = "tsql:windowed";
        public static final Class<?> WINDOWED_PROP_TYPE = Boolean.class;
        public static final boolean WINDOWED_PROP_MULTIPLE = false;
        public static final String DISTINCT_PROP_NAME = "tsql:distinct";
        public static final Class<?> DISTINCT_PROP_TYPE = Boolean.class;
        public static final boolean DISTINCT_PROP_MULTIPLE = false;
        public static final String CONDITION_REF_NAME = "tsql:condition";
        public static final Class<?> CONDITION_REF_TYPE = Expression.class;
        public static final boolean CONDITION_REF_MULTIPLE = false;
        public static final String ARGS_REF_NAME = "tsql:args";
        public static final Class<?> ARGS_REF_TYPE = Expression.class;
        public static final boolean ARGS_REF_MULTIPLE = true;
        public static final String ORDER_BY_REF_NAME = "tsql:orderBy";
        public static final Class<?> ORDER_BY_REF_TYPE = OrderBy.class;
        public static final boolean ORDER_BY_REF_MULTIPLE = false;
    }

    public static interface Function
    extends Expression {
        public static final String ID = "tsql:function";
        public static final boolean IS_ABSTRACT = false;
        public static final String IMPLICIT_PROP_NAME = "tsql:implicit";
        public static final Class<?> IMPLICIT_PROP_TYPE = Boolean.class;
        public static final boolean IMPLICIT_PROP_MULTIPLE = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String ARRAY_TYPE_PROP_NAME = "tsql:arrayType";
        public static final Class<?> ARRAY_TYPE_PROP_TYPE = Boolean.class;
        public static final boolean ARRAY_TYPE_PROP_MULTIPLE = false;
        public static final String ARGS_REF_NAME = "tsql:args";
        public static final Class<?> ARGS_REF_TYPE = Expression.class;
        public static final boolean ARGS_REF_MULTIPLE = true;
    }

    public static interface ExceptionExpression
    extends Expression {
        public static final String ID = "tsql:exceptionExpression";
        public static final boolean IS_ABSTRACT = false;
        public static final String PARENT_EXPRESSION_REF_NAME = "tsql:parentExpression";
        public static final Class<?> PARENT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean PARENT_EXPRESSION_REF_MULTIPLE = false;
        public static final String SQL_STATE_REF_NAME = "tsql:sqlState";
        public static final Class<?> SQL_STATE_REF_TYPE = Expression.class;
        public static final boolean SQL_STATE_REF_MULTIPLE = false;
        public static final String MESSAGE_REF_NAME = "tsql:message";
        public static final Class<?> MESSAGE_REF_TYPE = Expression.class;
        public static final boolean MESSAGE_REF_MULTIPLE = false;
        public static final String ERROR_CODE_REF_NAME = "tsql:errorCode";
        public static final Class<?> ERROR_CODE_REF_TYPE = Expression.class;
        public static final boolean ERROR_CODE_REF_MULTIPLE = false;
    }

    public static interface WhileStatement
    extends Statement,
    Labeled {
        public static final String ID = "tsql:whileStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String CONDITION_REF_NAME = "tsql:condition";
        public static final Class<?> CONDITION_REF_TYPE = Criteria.class;
        public static final boolean CONDITION_REF_MULTIPLE = false;
        public static final String BLOCK_REF_NAME = "tsql:block";
        public static final Class<?> BLOCK_REF_TYPE = Block.class;
        public static final boolean BLOCK_REF_MULTIPLE = false;
    }

    public static interface RaiseStatement
    extends Statement,
    ExpressionStatement {
        public static final String ID = "tsql:raiseStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String WARNING_PROP_NAME = "tsql:warning";
        public static final Class<?> WARNING_PROP_TYPE = Boolean.class;
        public static final boolean WARNING_PROP_MULTIPLE = false;
    }

    public static interface LoopStatement
    extends Statement,
    Labeled,
    SubqueryContainer {
        public static final String ID = "tsql:loopStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String CURSOR_NAME_PROP_NAME = "tsql:cursorName";
        public static final Class<?> CURSOR_NAME_PROP_TYPE = String.class;
        public static final boolean CURSOR_NAME_PROP_MULTIPLE = false;
        public static final String BLOCK_REF_NAME = "tsql:block";
        public static final Class<?> BLOCK_REF_TYPE = Block.class;
        public static final boolean BLOCK_REF_MULTIPLE = false;
    }

    public static interface IfStatement
    extends Statement {
        public static final String ID = "tsql:ifStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String IF_BLOCK_REF_NAME = "tsql:ifBlock";
        public static final Class<?> IF_BLOCK_REF_TYPE = Block.class;
        public static final boolean IF_BLOCK_REF_MULTIPLE = false;
        public static final String CONDITION_REF_NAME = "tsql:condition";
        public static final Class<?> CONDITION_REF_TYPE = Criteria.class;
        public static final boolean CONDITION_REF_MULTIPLE = false;
        public static final String ELSE_BLOCK_REF_NAME = "tsql:elseBlock";
        public static final Class<?> ELSE_BLOCK_REF_TYPE = Block.class;
        public static final boolean ELSE_BLOCK_REF_MULTIPLE = false;
    }

    public static interface CommandStatement
    extends Statement,
    SubqueryContainer {
        public static final String ID = "tsql:commandStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String RETURNABLE_PROP_NAME = "tsql:returnable";
        public static final Class<?> RETURNABLE_PROP_TYPE = Boolean.class;
        public static final boolean RETURNABLE_PROP_MULTIPLE = false;
    }

    public static interface BranchingStatement
    extends Statement {
        public static final String ID = "tsql:branchingStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String MODE_PROP_NAME = "tsql:mode";
        public static final Class<?> MODE_PROP_TYPE = String.class;
        public static final boolean MODE_PROP_MULTIPLE = false;
        public static final String[] MODE_PROP_CONSTRAINTS = new String[]{"BREAK", "CONTINUE", "LEAVE"};
        public static final String LABEL_PROP_NAME = "tsql:label";
        public static final Class<?> LABEL_PROP_TYPE = String.class;
        public static final boolean LABEL_PROP_MULTIPLE = false;
    }

    public static interface Block
    extends Statement,
    Labeled {
        public static final String ID = "tsql:block";
        public static final boolean IS_ABSTRACT = false;
        public static final String ATOMIC_PROP_NAME = "tsql:atomic";
        public static final Class<?> ATOMIC_PROP_TYPE = Boolean.class;
        public static final boolean ATOMIC_PROP_MULTIPLE = false;
        public static final String EXCEPTION_GROUP_PROP_NAME = "tsql:exceptionGroup";
        public static final Class<?> EXCEPTION_GROUP_PROP_TYPE = String.class;
        public static final boolean EXCEPTION_GROUP_PROP_MULTIPLE = false;
        public static final String EXCEPTION_STATEMENTS_REF_NAME = "tsql:exceptionStatements";
        public static final Class<?> EXCEPTION_STATEMENTS_REF_TYPE = Statement.class;
        public static final boolean EXCEPTION_STATEMENTS_REF_MULTIPLE = true;
        public static final String STATEMENTS_REF_NAME = "tsql:statements";
        public static final Class<?> STATEMENTS_REF_TYPE = Statement.class;
        public static final boolean STATEMENTS_REF_MULTIPLE = true;
    }

    public static interface ReturnStatement
    extends AssignmentStatement {
        public static final String ID = "tsql:returnStatement";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface DeclareStatement
    extends AssignmentStatement {
        public static final String ID = "tsql:declareStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String VARIABLE_TYPE_PROP_NAME = "tsql:variableType";
        public static final Class<?> VARIABLE_TYPE_PROP_TYPE = String.class;
        public static final boolean VARIABLE_TYPE_PROP_MULTIPLE = false;
    }

    public static interface AssignmentStatement
    extends Statement,
    ExpressionStatement {
        public static final String ID = "tsql:assignmentStatement";
        public static final boolean IS_ABSTRACT = false;
        public static final String VALUE_REF_NAME = "tsql:value";
        public static final Class<?> VALUE_REF_TYPE = Expression.class;
        public static final boolean VALUE_REF_MULTIPLE = false;
        public static final String VARIABLE_REF_NAME = "tsql:variable";
        public static final Class<?> VARIABLE_REF_TYPE = ElementSymbol.class;
        public static final boolean VARIABLE_REF_MULTIPLE = false;
        public static final String COMMAND_REF_NAME = "tsql:command";
        public static final Class<?> COMMAND_REF_TYPE = Command.class;
        public static final boolean COMMAND_REF_MULTIPLE = false;
    }

    public static interface Statement
    extends LanguageObject {
        public static final String ID = "tsql:statement";
        public static final boolean IS_ABSTRACT = true;
        public static final String TYPE_PROP_NAME = "tsql:type";
        public static final Class<?> TYPE_PROP_TYPE = String.class;
        public static final boolean TYPE_PROP_MULTIPLE = false;
        public static final String[] TYPE_PROP_CONSTRAINTS = new String[]{"TYPE_UNKNOWN", "TYPE_IF", "TYPE_COMMAND", "TYPE_DECLARE", "TYPE_ERROR", "TYPE_ASSIGNMENT", "TYPE_LOOP", "TYPE_WHILE", "TYPE_CONTINUE", "TYPE_BREAK", "TYPE_UPDATE", "TYPE_COMPOUND", "TYPE_LEAVE", "TYPE_RETURN"};
    }

    public static interface WithQueryCommand
    extends SubqueryContainer {
        public static final String ID = "tsql:withQueryCommand";
        public static final boolean IS_ABSTRACT = false;
        public static final String COLUMNS_REF_NAME = "tsql:columns";
        public static final Class<?> COLUMNS_REF_TYPE = ElementSymbol.class;
        public static final boolean COLUMNS_REF_MULTIPLE = true;
        public static final String GROUP_SYMBOL_REF_NAME = "tsql:groupSymbol";
        public static final Class<?> GROUP_SYMBOL_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_SYMBOL_REF_MULTIPLE = false;
        public static final String QUERY_EXPRESSION_REF_NAME = "tsql:queryExpression";
        public static final Class<?> QUERY_EXPRESSION_REF_TYPE = QueryCommand.class;
        public static final boolean QUERY_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface SubqueryHint
    extends LanguageObject {
        public static final String ID = "tsql:subqueryHint";
        public static final boolean IS_ABSTRACT = false;
        public static final String DJ = "DJ";
        public static final String MJ = "MJ";
        public static final String NO_UNNEST_PROP_NAME = "tsql:noUnnest";
        public static final Class<?> NO_UNNEST_PROP_TYPE = Boolean.class;
        public static final boolean NO_UNNEST_PROP_MULTIPLE = false;
        public static final String DEP_JOIN_PROP_NAME = "tsql:depJoin";
        public static final Class<?> DEP_JOIN_PROP_TYPE = Boolean.class;
        public static final boolean DEP_JOIN_PROP_MULTIPLE = false;
        public static final String MERGE_JOIN_PROP_NAME = "tsql:mergeJoin";
        public static final Class<?> MERGE_JOIN_PROP_TYPE = Boolean.class;
        public static final boolean MERGE_JOIN_PROP_MULTIPLE = false;
    }

    public static interface SpecificHint
    extends LanguageObject {
        public static final String ID = "tsql:specificHint";
        public static final boolean IS_ABSTRACT = false;
        public static final String HINT_PROP_NAME = "tsql:hint";
        public static final Class<?> HINT_PROP_TYPE = String.class;
        public static final boolean HINT_PROP_MULTIPLE = false;
        public static final String TRANSLATOR_NAME_PROP_NAME = "tsql:translatorName";
        public static final Class<?> TRANSLATOR_NAME_PROP_TYPE = String.class;
        public static final boolean TRANSLATOR_NAME_PROP_MULTIPLE = false;
        public static final String USE_ALIASES_PROP_NAME = "tsql:useAliases";
        public static final Class<?> USE_ALIASES_PROP_TYPE = Boolean.class;
        public static final boolean USE_ALIASES_PROP_MULTIPLE = false;
    }

    public static interface SourceHint
    extends LanguageObject {
        public static final String ID = "tsql:sourceHint";
        public static final boolean IS_ABSTRACT = false;
        public static final String GENERAL_HINT_PROP_NAME = "tsql:generalHint";
        public static final Class<?> GENERAL_HINT_PROP_TYPE = String.class;
        public static final boolean GENERAL_HINT_PROP_MULTIPLE = false;
        public static final String USE_ALIASES_PROP_NAME = "tsql:useAliases";
        public static final Class<?> USE_ALIASES_PROP_TYPE = Boolean.class;
        public static final boolean USE_ALIASES_PROP_MULTIPLE = false;
        public static final String SOURCE_HINTS_REF_NAME = "tsql:sourceHints";
        public static final Class<?> SOURCE_HINTS_REF_TYPE = SpecificHint.class;
        public static final boolean SOURCE_HINTS_REF_MULTIPLE = true;
    }

    public static interface CacheHint
    extends LanguageObject {
        public static final String ID = "tsql:cacheHint";
        public static final boolean IS_ABSTRACT = false;
        public static final String MIN_ROWS_PROP_NAME = "tsql:minRows";
        public static final Class<?> MIN_ROWS_PROP_TYPE = Long.class;
        public static final boolean MIN_ROWS_PROP_MULTIPLE = false;
        public static final String UPDATEABLE_PROP_NAME = "tsql:updateable";
        public static final Class<?> UPDATEABLE_PROP_TYPE = Boolean.class;
        public static final boolean UPDATEABLE_PROP_MULTIPLE = false;
        public static final String TTL_PROP_NAME = "tsql:ttl";
        public static final Class<?> TTL_PROP_TYPE = String.class;
        public static final boolean TTL_PROP_MULTIPLE = false;
        public static final String SCOPE_PROP_NAME = "tsql:scope";
        public static final Class<?> SCOPE_PROP_TYPE = String.class;
        public static final boolean SCOPE_PROP_MULTIPLE = false;
        public static final String INVALIDATION_PROP_NAME = "tsql:invalidation";
        public static final Class<?> INVALIDATION_PROP_TYPE = String.class;
        public static final boolean INVALIDATION_PROP_MULTIPLE = false;
        public static final String PREFERS_MEMORY_PROP_NAME = "tsql:prefersMemory";
        public static final Class<?> PREFERS_MEMORY_PROP_TYPE = Boolean.class;
        public static final boolean PREFERS_MEMORY_PROP_MULTIPLE = false;
        public static final String READ_ALL_PROP_NAME = "tsql:readAll";
        public static final Class<?> READ_ALL_PROP_TYPE = Boolean.class;
        public static final boolean READ_ALL_PROP_MULTIPLE = false;
    }

    public static interface SetClauseList
    extends LanguageObject {
        public static final String ID = "tsql:setClauseList";
        public static final boolean IS_ABSTRACT = false;
        public static final String SET_CLAUSES_REF_NAME = "tsql:setClauses";
        public static final Class<?> SET_CLAUSES_REF_TYPE = SetClause.class;
        public static final boolean SET_CLAUSES_REF_MULTIPLE = true;
    }

    public static interface SetClause
    extends LanguageObject {
        public static final String ID = "tsql:setClause";
        public static final boolean IS_ABSTRACT = false;
        public static final String VALUE_REF_NAME = "tsql:value";
        public static final Class<?> VALUE_REF_TYPE = Expression.class;
        public static final boolean VALUE_REF_MULTIPLE = false;
        public static final String SYMBOL_REF_NAME = "tsql:symbol";
        public static final Class<?> SYMBOL_REF_TYPE = ElementSymbol.class;
        public static final boolean SYMBOL_REF_MULTIPLE = false;
    }

    public static interface Select
    extends LanguageObject {
        public static final String ID = "tsql:select";
        public static final boolean IS_ABSTRACT = false;
        public static final String DISTINCT_PROP_NAME = "tsql:distinct";
        public static final Class<?> DISTINCT_PROP_TYPE = Boolean.class;
        public static final boolean DISTINCT_PROP_MULTIPLE = false;
        public static final String SYMBOLS_REF_NAME = "tsql:symbols";
        public static final Class<?> SYMBOLS_REF_TYPE = Expression.class;
        public static final boolean SYMBOLS_REF_MULTIPLE = true;
    }

    public static interface SPParameter
    extends LanguageObject {
        public static final String ID = "tsql:spParameter";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String VAR_ARG_PROP_NAME = "tsql:varArg";
        public static final Class<?> VAR_ARG_PROP_TYPE = Boolean.class;
        public static final boolean VAR_ARG_PROP_MULTIPLE = false;
        public static final String INDEX_PROP_NAME = "tsql:index";
        public static final Class<?> INDEX_PROP_TYPE = Long.class;
        public static final boolean INDEX_PROP_MULTIPLE = false;
        public static final String PARAMETER_TYPE_PROP_NAME = "tsql:parameterType";
        public static final Class<?> PARAMETER_TYPE_PROP_TYPE = Long.class;
        public static final boolean PARAMETER_TYPE_PROP_MULTIPLE = false;
        public static final String USING_DEFAULT_PROP_NAME = "tsql:usingDefault";
        public static final Class<?> USING_DEFAULT_PROP_TYPE = Boolean.class;
        public static final boolean USING_DEFAULT_PROP_MULTIPLE = false;
        public static final String METADATAID_PROP_NAME = "tsql:metadataiD";
        public static final Class<?> METADATAID_PROP_TYPE = String.class;
        public static final boolean METADATAID_PROP_MULTIPLE = false;
        public static final String CLASS_TYPE_CLASS_PROP_NAME = "tsql:classTypeClass";
        public static final Class<?> CLASS_TYPE_CLASS_PROP_TYPE = String.class;
        public static final boolean CLASS_TYPE_CLASS_PROP_MULTIPLE = false;
        public static final String RESULT_SET_COLUMN_REF_NAME = "tsql:resultSetColumn";
        public static final Class<?> RESULT_SET_COLUMN_REF_TYPE = ElementSymbol.class;
        public static final boolean RESULT_SET_COLUMN_REF_MULTIPLE = true;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface OrderByItem
    extends LanguageObject {
        public static final String ID = "tsql:orderByItem";
        public static final boolean IS_ABSTRACT = false;
        public static final String NULL_ORDERING_PROP_NAME = "tsql:nullOrdering";
        public static final Class<?> NULL_ORDERING_PROP_TYPE = String.class;
        public static final boolean NULL_ORDERING_PROP_MULTIPLE = false;
        public static final String[] NULL_ORDERING_PROP_CONSTRAINTS = new String[]{"FIRST", "LAST"};
        public static final String ASCENDING_PROP_NAME = "tsql:ascending";
        public static final Class<?> ASCENDING_PROP_TYPE = Boolean.class;
        public static final boolean ASCENDING_PROP_MULTIPLE = false;
        public static final String SYMBOL_REF_NAME = "tsql:symbol";
        public static final Class<?> SYMBOL_REF_TYPE = Expression.class;
        public static final boolean SYMBOL_REF_MULTIPLE = false;
    }

    public static interface OrderBy
    extends LanguageObject {
        public static final String ID = "tsql:orderBy";
        public static final boolean IS_ABSTRACT = false;
        public static final String ORDER_BY_ITEMS_REF_NAME = "tsql:orderByItems";
        public static final Class<?> ORDER_BY_ITEMS_REF_TYPE = OrderByItem.class;
        public static final boolean ORDER_BY_ITEMS_REF_MULTIPLE = true;
    }

    public static interface Option
    extends LanguageObject {
        public static final String ID = "tsql:option";
        public static final boolean IS_ABSTRACT = false;
        public static final String NO_CACHE_GROUPS_PROP_NAME = "tsql:noCacheGroups";
        public static final Class<?> NO_CACHE_GROUPS_PROP_TYPE = String.class;
        public static final boolean NO_CACHE_GROUPS_PROP_MULTIPLE = true;
        public static final String DEPENDENT_GROUPS_PROP_NAME = "tsql:dependentGroups";
        public static final Class<?> DEPENDENT_GROUPS_PROP_TYPE = String.class;
        public static final boolean DEPENDENT_GROUPS_PROP_MULTIPLE = true;
        public static final String NOT_DEPENDENT_GROUPS_PROP_NAME = "tsql:notDependentGroups";
        public static final Class<?> NOT_DEPENDENT_GROUPS_PROP_TYPE = String.class;
        public static final boolean NOT_DEPENDENT_GROUPS_PROP_MULTIPLE = true;
        public static final String NO_CACHE_PROP_NAME = "tsql:noCache";
        public static final Class<?> NO_CACHE_PROP_TYPE = Boolean.class;
        public static final boolean NO_CACHE_PROP_MULTIPLE = false;
        public static final String DEPENDENT_GROUP_OPTIONS_REF_NAME = "tsql:dependentGroupOptions";
        public static final Class<?> DEPENDENT_GROUP_OPTIONS_REF_TYPE = MakeDep.class;
        public static final boolean DEPENDENT_GROUP_OPTIONS_REF_MULTIPLE = true;
    }

    public static interface XMLColumn
    extends ProjectedColumn {
        public static final String ID = "tsql:xmlColumn";
        public static final boolean IS_ABSTRACT = false;
        public static final String ORDINAL_PROP_NAME = "tsql:ordinal";
        public static final Class<?> ORDINAL_PROP_TYPE = Boolean.class;
        public static final boolean ORDINAL_PROP_MULTIPLE = false;
        public static final String PATH_PROP_NAME = "tsql:path";
        public static final Class<?> PATH_PROP_TYPE = String.class;
        public static final boolean PATH_PROP_MULTIPLE = false;
        public static final String DEFAULT_EXPRESSION_REF_NAME = "tsql:defaultExpression";
        public static final Class<?> DEFAULT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean DEFAULT_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface TextColumn
    extends ProjectedColumn {
        public static final String ID = "tsql:textColumn";
        public static final boolean IS_ABSTRACT = false;
        public static final String NO_TRIM_PROP_NAME = "tsql:noTrim";
        public static final Class<?> NO_TRIM_PROP_TYPE = Boolean.class;
        public static final boolean NO_TRIM_PROP_MULTIPLE = false;
        public static final String ORDINAL_PROP_NAME = "tsql:ordinal";
        public static final Class<?> ORDINAL_PROP_TYPE = Boolean.class;
        public static final boolean ORDINAL_PROP_MULTIPLE = false;
        public static final DefaultTeiidVersion.Version ORDINAL_PROP_SINCE_VERSION = DefaultTeiidVersion.Version.TEIID_8_7;
        public static final String SELECTOR_PROP_NAME = "tsql:selector";
        public static final Class<?> SELECTOR_PROP_TYPE = String.class;
        public static final boolean SELECTOR_PROP_MULTIPLE = false;
        public static final String WIDTH_PROP_NAME = "tsql:width";
        public static final Class<?> WIDTH_PROP_TYPE = Long.class;
        public static final boolean WIDTH_PROP_MULTIPLE = false;
        public static final String POSITION_PROP_NAME = "tsql:position";
        public static final Class<?> POSITION_PROP_TYPE = Long.class;
        public static final boolean POSITION_PROP_MULTIPLE = false;
        public static final String HEADER_PROP_NAME = "tsql:header";
        public static final Class<?> HEADER_PROP_TYPE = String.class;
        public static final boolean HEADER_PROP_MULTIPLE = false;
    }

    public static interface ObjectColumn
    extends ProjectedColumn {
        public static final String ID = "tsql:objectColumn";
        public static final boolean IS_ABSTRACT = false;
        public static final String PATH_PROP_NAME = "tsql:path";
        public static final Class<?> PATH_PROP_TYPE = String.class;
        public static final boolean PATH_PROP_MULTIPLE = false;
        public static final String DEFAULT_EXPRESSION_REF_NAME = "tsql:defaultExpression";
        public static final Class<?> DEFAULT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean DEFAULT_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface ProjectedColumn
    extends LanguageObject {
        public static final String ID = "tsql:projectedColumn";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String TYPE_PROP_NAME = "tsql:type";
        public static final Class<?> TYPE_PROP_TYPE = String.class;
        public static final boolean TYPE_PROP_MULTIPLE = false;
    }

    public static interface NullNode
    extends LanguageObject {
        public static final String ID = "tsql:nullNode";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface NamespaceItem
    extends LanguageObject {
        public static final String ID = "tsql:namespaceItem";
        public static final boolean IS_ABSTRACT = false;
        public static final String PREFIX_PROP_NAME = "tsql:prefix";
        public static final Class<?> PREFIX_PROP_TYPE = String.class;
        public static final boolean PREFIX_PROP_MULTIPLE = false;
        public static final String URI_PROP_NAME = "tsql:uri";
        public static final Class<?> URI_PROP_TYPE = String.class;
        public static final boolean URI_PROP_MULTIPLE = false;
    }

    public static interface MakeDep
    extends LanguageObject {
        public static final String ID = "tsql:makeDep";
        public static final boolean IS_ABSTRACT = false;
        public static final String JOIN_PROP_NAME = "tsql:join";
        public static final Class<?> JOIN_PROP_TYPE = Boolean.class;
        public static final boolean JOIN_PROP_MULTIPLE = false;
        public static final String MAX_PROP_NAME = "tsql:max";
        public static final Class<?> MAX_PROP_TYPE = Long.class;
        public static final boolean MAX_PROP_MULTIPLE = false;
    }

    public static interface Limit
    extends LanguageObject {
        public static final String ID = "tsql:limit";
        public static final boolean IS_ABSTRACT = false;
        public static final String NON_STRICT = "NON_STRICT";
        public static final String IMPLICIT_PROP_NAME = "tsql:implicit";
        public static final Class<?> IMPLICIT_PROP_TYPE = Boolean.class;
        public static final boolean IMPLICIT_PROP_MULTIPLE = false;
        public static final String STRICT_PROP_NAME = "tsql:strict";
        public static final Class<?> STRICT_PROP_TYPE = Boolean.class;
        public static final boolean STRICT_PROP_MULTIPLE = false;
        public static final String OFFSET_REF_NAME = "tsql:offset";
        public static final Class<?> OFFSET_REF_TYPE = Expression.class;
        public static final boolean OFFSET_REF_MULTIPLE = false;
        public static final String ROW_LIMIT_REF_NAME = "tsql:rowLimit";
        public static final Class<?> ROW_LIMIT_REF_TYPE = Expression.class;
        public static final boolean ROW_LIMIT_REF_MULTIPLE = false;
    }

    public static interface JoinType
    extends LanguageObject {
        public static final String ID = "tsql:joinType";
        public static final boolean IS_ABSTRACT = false;
        public static final String KIND_PROP_NAME = "tsql:kind";
        public static final Class<?> KIND_PROP_TYPE = String.class;
        public static final boolean KIND_PROP_MULTIPLE = false;
        public static final String[] KIND_PROP_CONSTRAINTS = new String[]{"JOIN_INNER", "JOIN_RIGHT_OUTER", "JOIN_LEFT_OUTER", "JOIN_FULL_OUTER", "JOIN_CROSS", "JOIN_UNION", "JOIN_SEMI", "JOIN_ANTI_SEMI"};
    }

    public static interface Into
    extends LanguageObject {
        public static final String ID = "tsql:into";
        public static final boolean IS_ABSTRACT = false;
        public static final String GROUP_REF_NAME = "tsql:group";
        public static final Class<?> GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_REF_MULTIPLE = false;
    }

    public static interface GroupBy
    extends LanguageObject {
        public static final String ID = "tsql:groupBy";
        public static final boolean IS_ABSTRACT = false;
        public static final String ROLLUP_PROP_NAME = "tsql:rollup";
        public static final Class<?> ROLLUP_PROP_TYPE = Boolean.class;
        public static final boolean ROLLUP_PROP_MULTIPLE = false;
        public static final DefaultTeiidVersion.Version ROLLUP_PROP_SINCE_VERSION = DefaultTeiidVersion.Version.TEIID_8_5;
        public static final String SYMBOLS_REF_NAME = "tsql:symbols";
        public static final Class<?> SYMBOLS_REF_TYPE = Expression.class;
        public static final boolean SYMBOLS_REF_MULTIPLE = true;
    }

    public static interface From
    extends LanguageObject {
        public static final String ID = "tsql:from";
        public static final boolean IS_ABSTRACT = false;
        public static final String CLAUSES_REF_NAME = "tsql:clauses";
        public static final Class<?> CLAUSES_REF_TYPE = FromClause.class;
        public static final boolean CLAUSES_REF_MULTIPLE = true;
    }

    public static interface UnaryFromClause
    extends FromClause {
        public static final String ID = "tsql:unaryFromClause";
        public static final boolean IS_ABSTRACT = false;
        public static final String GROUP_REF_NAME = "tsql:group";
        public static final Class<?> GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_REF_MULTIPLE = false;
        public static final String EXPANDED_COMMAND_REF_NAME = "tsql:expandedCommand";
        public static final Class<?> EXPANDED_COMMAND_REF_TYPE = Command.class;
        public static final boolean EXPANDED_COMMAND_REF_MULTIPLE = false;
    }

    public static interface SubqueryFromClause
    extends FromClause,
    SubqueryContainer {
        public static final String ID = "tsql:subqueryFromClause";
        public static final boolean IS_ABSTRACT = false;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
        public static final String TABLE_PROP_NAME = "tsql:table";
        public static final Class<?> TABLE_PROP_TYPE = Boolean.class;
        public static final boolean TABLE_PROP_MULTIPLE = false;
        public static final String LATERAL_PROP_NAME = "tsql:lateral";
        public static final Class<?> LATERAL_PROP_TYPE = Boolean.class;
        public static final boolean LATERAL_PROP_MULTIPLE = false;
    }

    public static interface JoinPredicate
    extends FromClause {
        public static final String ID = "tsql:joinPredicate";
        public static final boolean IS_ABSTRACT = false;
        public static final String JOIN_TYPE_REF_NAME = "tsql:joinType";
        public static final Class<?> JOIN_TYPE_REF_TYPE = JoinType.class;
        public static final boolean JOIN_TYPE_REF_MULTIPLE = false;
        public static final String RIGHT_CLAUSE_REF_NAME = "tsql:rightClause";
        public static final Class<?> RIGHT_CLAUSE_REF_TYPE = FromClause.class;
        public static final boolean RIGHT_CLAUSE_REF_MULTIPLE = false;
        public static final String JOIN_CRITERIA_REF_NAME = "tsql:joinCriteria";
        public static final Class<?> JOIN_CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean JOIN_CRITERIA_REF_MULTIPLE = true;
        public static final String LEFT_CLAUSE_REF_NAME = "tsql:leftClause";
        public static final Class<?> LEFT_CLAUSE_REF_TYPE = FromClause.class;
        public static final boolean LEFT_CLAUSE_REF_MULTIPLE = false;
    }

    public static interface XMLTable
    extends TableFunctionReference {
        public static final String ID = "tsql:xmlTable";
        public static final boolean IS_ABSTRACT = false;
        public static final String XQUERY_PROP_NAME = "tsql:xquery";
        public static final Class<?> XQUERY_PROP_TYPE = String.class;
        public static final boolean XQUERY_PROP_MULTIPLE = false;
        public static final String USING_DEFAULT_COLUMN_PROP_NAME = "tsql:usingDefaultColumn";
        public static final Class<?> USING_DEFAULT_COLUMN_PROP_TYPE = Boolean.class;
        public static final boolean USING_DEFAULT_COLUMN_PROP_MULTIPLE = false;
        public static final String COLUMNS_REF_NAME = "tsql:columns";
        public static final Class<?> COLUMNS_REF_TYPE = XMLColumn.class;
        public static final boolean COLUMNS_REF_MULTIPLE = true;
        public static final String NAMESPACES_REF_NAME = "tsql:namespaces";
        public static final Class<?> NAMESPACES_REF_TYPE = XMLNamespaces.class;
        public static final boolean NAMESPACES_REF_MULTIPLE = false;
        public static final String PASSING_REF_NAME = "tsql:passing";
        public static final Class<?> PASSING_REF_TYPE = DerivedColumn.class;
        public static final boolean PASSING_REF_MULTIPLE = true;
    }

    public static interface TextTable
    extends TableFunctionReference {
        public static final String ID = "tsql:textTable";
        public static final boolean IS_ABSTRACT = false;
        public static final String QUOTE_PROP_NAME = "tsql:quote";
        public static final Class<?> QUOTE_PROP_TYPE = String.class;
        public static final boolean QUOTE_PROP_MULTIPLE = false;
        public static final String USING_ROW_DELIMITER_PROP_NAME = "tsql:usingRowDelimiter";
        public static final Class<?> USING_ROW_DELIMITER_PROP_TYPE = Boolean.class;
        public static final boolean USING_ROW_DELIMITER_PROP_MULTIPLE = false;
        public static final String SKIP_PROP_NAME = "tsql:skip";
        public static final Class<?> SKIP_PROP_TYPE = Long.class;
        public static final boolean SKIP_PROP_MULTIPLE = false;
        public static final String DELIMITER_PROP_NAME = "tsql:delimiter";
        public static final Class<?> DELIMITER_PROP_TYPE = String.class;
        public static final boolean DELIMITER_PROP_MULTIPLE = false;
        public static final String SELECTOR_PROP_NAME = "tsql:selector";
        public static final Class<?> SELECTOR_PROP_TYPE = String.class;
        public static final boolean SELECTOR_PROP_MULTIPLE = false;
        public static final String ESCAPE_PROP_NAME = "tsql:escape";
        public static final Class<?> ESCAPE_PROP_TYPE = Boolean.class;
        public static final boolean ESCAPE_PROP_MULTIPLE = false;
        public static final String HEADER_PROP_NAME = "tsql:header";
        public static final Class<?> HEADER_PROP_TYPE = Long.class;
        public static final boolean HEADER_PROP_MULTIPLE = false;
        public static final String FIXED_WIDTH_PROP_NAME = "tsql:fixedWidth";
        public static final Class<?> FIXED_WIDTH_PROP_TYPE = Boolean.class;
        public static final boolean FIXED_WIDTH_PROP_MULTIPLE = false;
        public static final String COLUMNS_REF_NAME = "tsql:columns";
        public static final Class<?> COLUMNS_REF_TYPE = TextColumn.class;
        public static final boolean COLUMNS_REF_MULTIPLE = true;
        public static final String FILE_REF_NAME = "tsql:file";
        public static final Class<?> FILE_REF_TYPE = Expression.class;
        public static final boolean FILE_REF_MULTIPLE = false;
    }

    public static interface ObjectTable
    extends TableFunctionReference {
        public static final String ID = "tsql:objectTable";
        public static final boolean IS_ABSTRACT = false;
        public static final String ROW_SCRIPT_PROP_NAME = "tsql:rowScript";
        public static final Class<?> ROW_SCRIPT_PROP_TYPE = String.class;
        public static final boolean ROW_SCRIPT_PROP_MULTIPLE = false;
        public static final String SCRIPTING_LANGUAGE_PROP_NAME = "tsql:scriptingLanguage";
        public static final Class<?> SCRIPTING_LANGUAGE_PROP_TYPE = String.class;
        public static final boolean SCRIPTING_LANGUAGE_PROP_MULTIPLE = false;
        public static final String COLUMNS_REF_NAME = "tsql:columns";
        public static final Class<?> COLUMNS_REF_TYPE = ObjectColumn.class;
        public static final boolean COLUMNS_REF_MULTIPLE = true;
        public static final String PASSING_REF_NAME = "tsql:passing";
        public static final Class<?> PASSING_REF_TYPE = DerivedColumn.class;
        public static final boolean PASSING_REF_MULTIPLE = true;
    }

    public static interface ArrayTable
    extends TableFunctionReference {
        public static final String ID = "tsql:arrayTable";
        public static final boolean IS_ABSTRACT = false;
        public static final String COLUMNS_REF_NAME = "tsql:columns";
        public static final Class<?> COLUMNS_REF_TYPE = ProjectedColumn.class;
        public static final boolean COLUMNS_REF_MULTIPLE = true;
        public static final String ARRAY_VALUE_REF_NAME = "tsql:arrayValue";
        public static final Class<?> ARRAY_VALUE_REF_TYPE = Expression.class;
        public static final boolean ARRAY_VALUE_REF_MULTIPLE = false;
    }

    public static interface TableFunctionReference
    extends FromClause {
        public static final String ID = "tsql:tableFunctionReference";
        public static final boolean IS_ABSTRACT = true;
        public static final String NAME_PROP_NAME = "tsql:name";
        public static final Class<?> NAME_PROP_TYPE = String.class;
        public static final boolean NAME_PROP_MULTIPLE = false;
    }

    public static interface FromClause
    extends LanguageObject {
        public static final String ID = "tsql:fromClause";
        public static final boolean IS_ABSTRACT = true;
        public static final String MAKE_IND_PROP_NAME = "tsql:makeInd";
        public static final Class<?> MAKE_IND_PROP_TYPE = Boolean.class;
        public static final boolean MAKE_IND_PROP_MULTIPLE = false;
        public static final String NO_UNNEST_PROP_NAME = "tsql:noUnnest";
        public static final Class<?> NO_UNNEST_PROP_TYPE = Boolean.class;
        public static final boolean NO_UNNEST_PROP_MULTIPLE = false;
        public static final String MAKE_DEP_PROP_NAME = "tsql:makeDep";
        public static final Class<?> MAKE_DEP_PROP_TYPE = Boolean.class;
        public static final boolean MAKE_DEP_PROP_MULTIPLE = false;
        public static final String PRESERVE_PROP_NAME = "tsql:preserve";
        public static final Class<?> PRESERVE_PROP_TYPE = Boolean.class;
        public static final boolean PRESERVE_PROP_MULTIPLE = false;
        public static final String MAKE_NOT_DEP_PROP_NAME = "tsql:makeNotDep";
        public static final Class<?> MAKE_NOT_DEP_PROP_TYPE = Boolean.class;
        public static final boolean MAKE_NOT_DEP_PROP_MULTIPLE = false;
        public static final String OPTIONAL_PROP_NAME = "tsql:optional";
        public static final Class<?> OPTIONAL_PROP_TYPE = Boolean.class;
        public static final boolean OPTIONAL_PROP_MULTIPLE = false;
        public static final String MAKE_DEPENDENCY_REF_NAME = "tsql:makeDependency";
        public static final Class<?> MAKE_DEPENDENCY_REF_TYPE = MakeDep.class;
        public static final boolean MAKE_DEPENDENCY_REF_MULTIPLE = false;
    }

    public static interface TriggerAction
    extends Command {
        public static final String ID = "tsql:triggerAction";
        public static final boolean IS_ABSTRACT = false;
        public static final String BLOCK_REF_NAME = "tsql:block";
        public static final Class<?> BLOCK_REF_TYPE = Block.class;
        public static final boolean BLOCK_REF_MULTIPLE = false;
    }

    public static interface CreateProcedureCommand
    extends Command {
        public static final String ID = "tsql:createProcedureCommand";
        public static final boolean IS_ABSTRACT = false;
        public static final String VIRTUAL_GROUP_REF_NAME = "tsql:virtualGroup";
        public static final Class<?> VIRTUAL_GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean VIRTUAL_GROUP_REF_MULTIPLE = false;
        public static final String BLOCK_REF_NAME = "tsql:block";
        public static final Class<?> BLOCK_REF_TYPE = Block.class;
        public static final boolean BLOCK_REF_MULTIPLE = false;
    }

    public static interface SetQuery
    extends QueryCommand {
        public static final String ID = "tsql:setQuery";
        public static final boolean IS_ABSTRACT = false;
        public static final String OPERATION_PROP_NAME = "tsql:operation";
        public static final Class<?> OPERATION_PROP_TYPE = String.class;
        public static final boolean OPERATION_PROP_MULTIPLE = false;
        public static final String[] OPERATION_PROP_CONSTRAINTS = new String[]{"UNION", "INTERSECT", "EXCEPT"};
        public static final String ALL_PROP_NAME = "tsql:all";
        public static final Class<?> ALL_PROP_TYPE = Boolean.class;
        public static final boolean ALL_PROP_MULTIPLE = false;
        public static final String RIGHT_QUERY_REF_NAME = "tsql:rightQuery";
        public static final Class<?> RIGHT_QUERY_REF_TYPE = QueryCommand.class;
        public static final boolean RIGHT_QUERY_REF_MULTIPLE = false;
        public static final String LEFT_QUERY_REF_NAME = "tsql:leftQuery";
        public static final Class<?> LEFT_QUERY_REF_TYPE = QueryCommand.class;
        public static final boolean LEFT_QUERY_REF_MULTIPLE = false;
    }

    public static interface Query
    extends QueryCommand {
        public static final String ID = "tsql:query";
        public static final boolean IS_ABSTRACT = false;
        public static final String ROW_CONSTRUCTOR_PROP_NAME = "tsql:rowConstructor";
        public static final Class<?> ROW_CONSTRUCTOR_PROP_TYPE = Boolean.class;
        public static final boolean ROW_CONSTRUCTOR_PROP_MULTIPLE = false;
        public static final String SELECT_REF_NAME = "tsql:select";
        public static final Class<?> SELECT_REF_TYPE = Select.class;
        public static final boolean SELECT_REF_MULTIPLE = false;
        public static final String HAVING_REF_NAME = "tsql:having";
        public static final Class<?> HAVING_REF_TYPE = Criteria.class;
        public static final boolean HAVING_REF_MULTIPLE = false;
        public static final String FROM_REF_NAME = "tsql:from";
        public static final Class<?> FROM_REF_TYPE = From.class;
        public static final boolean FROM_REF_MULTIPLE = false;
        public static final String INTO_REF_NAME = "tsql:into";
        public static final Class<?> INTO_REF_TYPE = Into.class;
        public static final boolean INTO_REF_MULTIPLE = false;
        public static final String CRITERIA_REF_NAME = "tsql:criteria";
        public static final Class<?> CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean CRITERIA_REF_MULTIPLE = false;
        public static final String GROUP_BY_REF_NAME = "tsql:groupBy";
        public static final Class<?> GROUP_BY_REF_TYPE = GroupBy.class;
        public static final boolean GROUP_BY_REF_MULTIPLE = false;
    }

    public static interface QueryCommand
    extends Command {
        public static final String ID = "tsql:queryCommand";
        public static final boolean IS_ABSTRACT = true;
        public static final String LIMIT_REF_NAME = "tsql:limit";
        public static final Class<?> LIMIT_REF_TYPE = Limit.class;
        public static final boolean LIMIT_REF_MULTIPLE = false;
        public static final String ORDER_BY_REF_NAME = "tsql:orderBy";
        public static final Class<?> ORDER_BY_REF_TYPE = OrderBy.class;
        public static final boolean ORDER_BY_REF_MULTIPLE = false;
        public static final String WITH_REF_NAME = "tsql:with";
        public static final Class<?> WITH_REF_TYPE = WithQueryCommand.class;
        public static final boolean WITH_REF_MULTIPLE = true;
    }

    public static interface DynamicCommand
    extends Command {
        public static final String ID = "tsql:dynamicCommand";
        public static final boolean IS_ABSTRACT = false;
        public static final String UPDATING_MODEL_COUNT_PROP_NAME = "tsql:updatingModelCount";
        public static final Class<?> UPDATING_MODEL_COUNT_PROP_TYPE = Long.class;
        public static final boolean UPDATING_MODEL_COUNT_PROP_MULTIPLE = false;
        public static final String AS_CLAUSE_SET_PROP_NAME = "tsql:asClauseSet";
        public static final Class<?> AS_CLAUSE_SET_PROP_TYPE = Boolean.class;
        public static final boolean AS_CLAUSE_SET_PROP_MULTIPLE = false;
        public static final String USING_REF_NAME = "tsql:using";
        public static final Class<?> USING_REF_TYPE = SetClauseList.class;
        public static final boolean USING_REF_MULTIPLE = false;
        public static final String INTO_GROUP_REF_NAME = "tsql:intoGroup";
        public static final Class<?> INTO_GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean INTO_GROUP_REF_MULTIPLE = false;
        public static final String AS_COLUMNS_REF_NAME = "tsql:asColumns";
        public static final Class<?> AS_COLUMNS_REF_TYPE = ElementSymbol.class;
        public static final boolean AS_COLUMNS_REF_MULTIPLE = true;
        public static final String SQL_REF_NAME = "tsql:sql";
        public static final Class<?> SQL_REF_TYPE = Expression.class;
        public static final boolean SQL_REF_MULTIPLE = false;
    }

    public static interface Update
    extends ProcedureContainer,
    TargetedCommand {
        public static final String ID = "tsql:update";
        public static final boolean IS_ABSTRACT = false;
        public static final String CRITERIA_REF_NAME = "tsql:criteria";
        public static final Class<?> CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean CRITERIA_REF_MULTIPLE = false;
        public static final String CHANGE_LIST_REF_NAME = "tsql:changeList";
        public static final Class<?> CHANGE_LIST_REF_TYPE = SetClauseList.class;
        public static final boolean CHANGE_LIST_REF_MULTIPLE = false;
    }

    public static interface StoredProcedure
    extends ProcedureContainer,
    TargetedCommand {
        public static final String ID = "tsql:storedProcedure";
        public static final boolean IS_ABSTRACT = false;
        public static final String CALLABLE_STATEMENT_PROP_NAME = "tsql:callableStatement";
        public static final Class<?> CALLABLE_STATEMENT_PROP_TYPE = Boolean.class;
        public static final boolean CALLABLE_STATEMENT_PROP_MULTIPLE = false;
        public static final String PROCEDUREID_PROP_NAME = "tsql:procedureiD";
        public static final Class<?> PROCEDUREID_PROP_TYPE = String.class;
        public static final boolean PROCEDUREID_PROP_MULTIPLE = false;
        public static final String PROCEDURE_CALLABLE_NAME_PROP_NAME = "tsql:procedureCallableName";
        public static final Class<?> PROCEDURE_CALLABLE_NAME_PROP_TYPE = String.class;
        public static final boolean PROCEDURE_CALLABLE_NAME_PROP_MULTIPLE = false;
        public static final String PROCEDURE_NAME_PROP_NAME = "tsql:procedureName";
        public static final Class<?> PROCEDURE_NAME_PROP_TYPE = String.class;
        public static final boolean PROCEDURE_NAME_PROP_MULTIPLE = false;
        public static final String DISPLAY_NAMED_PARAMETERS_PROP_NAME = "tsql:displayNamedParameters";
        public static final Class<?> DISPLAY_NAMED_PARAMETERS_PROP_TYPE = Boolean.class;
        public static final boolean DISPLAY_NAMED_PARAMETERS_PROP_MULTIPLE = false;
        public static final String CALLED_WITH_RETURN_PROP_NAME = "tsql:calledWithReturn";
        public static final Class<?> CALLED_WITH_RETURN_PROP_TYPE = Boolean.class;
        public static final boolean CALLED_WITH_RETURN_PROP_MULTIPLE = false;
        public static final String PARAMETERS_REF_NAME = "tsql:parameters";
        public static final Class<?> PARAMETERS_REF_TYPE = SPParameter.class;
        public static final boolean PARAMETERS_REF_MULTIPLE = true;
    }

    public static interface Insert
    extends ProcedureContainer,
    TargetedCommand {
        public static final String ID = "tsql:insert";
        public static final boolean IS_ABSTRACT = false;
        public static final String MERGE_PROP_NAME = "tsql:merge";
        public static final Class<?> MERGE_PROP_TYPE = Boolean.class;
        public static final boolean MERGE_PROP_MULTIPLE = false;
        public static final String VARIABLES_REF_NAME = "tsql:variables";
        public static final Class<?> VARIABLES_REF_TYPE = ElementSymbol.class;
        public static final boolean VARIABLES_REF_MULTIPLE = true;
        public static final String VALUES_REF_NAME = "tsql:values";
        public static final Class<?> VALUES_REF_TYPE = Expression.class;
        public static final boolean VALUES_REF_MULTIPLE = true;
        public static final String QUERY_EXPRESSION_REF_NAME = "tsql:queryExpression";
        public static final Class<?> QUERY_EXPRESSION_REF_TYPE = QueryCommand.class;
        public static final boolean QUERY_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface Delete
    extends ProcedureContainer,
    TargetedCommand {
        public static final String ID = "tsql:delete";
        public static final boolean IS_ABSTRACT = false;
        public static final String CRITERIA_REF_NAME = "tsql:criteria";
        public static final Class<?> CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean CRITERIA_REF_MULTIPLE = false;
    }

    public static interface ProcedureContainer
    extends Command {
        public static final String ID = "tsql:procedureContainer";
        public static final boolean IS_ABSTRACT = true;
    }

    public static interface AlterView
    extends Alter {
        public static final String ID = "tsql:alterView";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface AlterTrigger
    extends Alter {
        public static final String ID = "tsql:alterTrigger";
        public static final boolean IS_ABSTRACT = false;
        public static final String ENABLED_PROP_NAME = "tsql:enabled";
        public static final Class<?> ENABLED_PROP_TYPE = Boolean.class;
        public static final boolean ENABLED_PROP_MULTIPLE = false;
        public static final String EVENT_PROP_NAME = "tsql:event";
        public static final Class<?> EVENT_PROP_TYPE = String.class;
        public static final boolean EVENT_PROP_MULTIPLE = false;
        public static final String[] EVENT_PROP_CONSTRAINTS = new String[]{"INSERT", "UPDATE", "DELETE"};
        public static final String CREATE_PROP_NAME = "tsql:create";
        public static final Class<?> CREATE_PROP_TYPE = Boolean.class;
        public static final boolean CREATE_PROP_MULTIPLE = false;
    }

    public static interface AlterProcedure
    extends Alter {
        public static final String ID = "tsql:alterProcedure";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface Alter
    extends Command {
        public static final String ID = "tsql:alter";
        public static final boolean IS_ABSTRACT = true;
        public static final String TARGET_REF_NAME = "tsql:target";
        public static final Class<?> TARGET_REF_TYPE = GroupSymbol.class;
        public static final boolean TARGET_REF_MULTIPLE = false;
        public static final String DEFINITION_REF_NAME = "tsql:definition";
        public static final Class<?> DEFINITION_REF_TYPE = Command.class;
        public static final boolean DEFINITION_REF_MULTIPLE = false;
    }

    public static interface Command
    extends LanguageObject {
        public static final String ID = "tsql:command";
        public static final boolean IS_ABSTRACT = true;
        public static final String IS_RESOLVED_PROP_NAME = "tsql:isResolved";
        public static final Class<?> IS_RESOLVED_PROP_TYPE = Boolean.class;
        public static final boolean IS_RESOLVED_PROP_MULTIPLE = false;
        public static final String TYPE_PROP_NAME = "tsql:type";
        public static final Class<?> TYPE_PROP_TYPE = Long.class;
        public static final boolean TYPE_PROP_MULTIPLE = false;
        public static final String OPTION_REF_NAME = "tsql:option";
        public static final Class<?> OPTION_REF_TYPE = Option.class;
        public static final boolean OPTION_REF_MULTIPLE = false;
        public static final String SOURCE_HINT_REF_NAME = "tsql:sourceHint";
        public static final Class<?> SOURCE_HINT_REF_TYPE = SourceHint.class;
        public static final boolean SOURCE_HINT_REF_MULTIPLE = false;
        public static final String CACHE_HINT_REF_NAME = "tsql:cacheHint";
        public static final Class<?> CACHE_HINT_REF_TYPE = CacheHint.class;
        public static final boolean CACHE_HINT_REF_MULTIPLE = false;
    }

    public static interface NotCriteria
    extends Criteria {
        public static final String ID = "tsql:notCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String CRITERIA_REF_NAME = "tsql:criteria";
        public static final Class<?> CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean CRITERIA_REF_MULTIPLE = false;
    }

    public static interface MatchCriteria
    extends Criteria,
    PredicateCriteria {
        public static final String ID = "tsql:matchCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String ESCAPE_CHAR_PROP_NAME = "tsql:escapeChar";
        public static final Class<?> ESCAPE_CHAR_PROP_TYPE = String.class;
        public static final boolean ESCAPE_CHAR_PROP_MULTIPLE = false;
        public static final String MODE_PROP_NAME = "tsql:mode";
        public static final Class<?> MODE_PROP_TYPE = String.class;
        public static final boolean MODE_PROP_MULTIPLE = false;
        public static final String[] MODE_PROP_CONSTRAINTS = new String[]{"LIKE", "SIMILAR", "REGEX"};
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String RIGHT_EXPRESSION_REF_NAME = "tsql:rightExpression";
        public static final Class<?> RIGHT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean RIGHT_EXPRESSION_REF_MULTIPLE = false;
        public static final String LEFT_EXPRESSION_REF_NAME = "tsql:leftExpression";
        public static final Class<?> LEFT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean LEFT_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface IsNullCriteria
    extends Criteria,
    PredicateCriteria {
        public static final String ID = "tsql:isNullCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface ExpressionCriteria
    extends Criteria {
        public static final String ID = "tsql:expressionCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface ExistsCriteria
    extends Criteria,
    PredicateCriteria,
    SubqueryContainer {
        public static final String ID = "tsql:existsCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String SUBQUERY_HINT_REF_NAME = "tsql:subqueryHint";
        public static final Class<?> SUBQUERY_HINT_REF_TYPE = SubqueryHint.class;
        public static final boolean SUBQUERY_HINT_REF_MULTIPLE = false;
    }

    public static interface CompoundCriteria
    extends Criteria {
        public static final String ID = "tsql:compoundCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String OPERATOR_PROP_NAME = "tsql:operator";
        public static final Class<?> OPERATOR_PROP_TYPE = Long.class;
        public static final boolean OPERATOR_PROP_MULTIPLE = false;
        public static final String CRITERIA_REF_NAME = "tsql:criteria";
        public static final Class<?> CRITERIA_REF_TYPE = Criteria.class;
        public static final boolean CRITERIA_REF_MULTIPLE = true;
    }

    public static interface BetweenCriteria
    extends Criteria,
    PredicateCriteria {
        public static final String ID = "tsql:betweenCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String LOWER_EXPRESSION_REF_NAME = "tsql:lowerExpression";
        public static final Class<?> LOWER_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean LOWER_EXPRESSION_REF_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
        public static final String UPPER_EXPRESSION_REF_NAME = "tsql:upperExpression";
        public static final Class<?> UPPER_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean UPPER_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface SubquerySetCriteria
    extends AbstractSetCriteria,
    SubqueryContainer {
        public static final String ID = "tsql:subquerySetCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String SUBQUERY_HINT_REF_NAME = "tsql:subqueryHint";
        public static final Class<?> SUBQUERY_HINT_REF_TYPE = SubqueryHint.class;
        public static final boolean SUBQUERY_HINT_REF_MULTIPLE = false;
    }

    public static interface SetCriteria
    extends AbstractSetCriteria {
        public static final String ID = "tsql:setCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String VALUES_REF_NAME = "tsql:values";
        public static final Class<?> VALUES_REF_TYPE = Expression.class;
        public static final boolean VALUES_REF_MULTIPLE = true;
    }

    public static interface AbstractSetCriteria
    extends Criteria,
    PredicateCriteria {
        public static final String ID = "tsql:abstractSetCriteria";
        public static final boolean IS_ABSTRACT = true;
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface SubqueryCompareCriteria
    extends AbstractCompareCriteria,
    SubqueryContainer {
        public static final String ID = "tsql:subqueryCompareCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String PREDICATE_QUANTIFIER_PROP_NAME = "tsql:predicateQuantifier";
        public static final Class<?> PREDICATE_QUANTIFIER_PROP_TYPE = String.class;
        public static final boolean PREDICATE_QUANTIFIER_PROP_MULTIPLE = false;
        public static final String[] PREDICATE_QUANTIFIER_PROP_CONSTRAINTS = new String[]{"SOME", "ANY", "ALL"};
    }

    public static interface CompareCriteria
    extends AbstractCompareCriteria {
        public static final String ID = "tsql:compareCriteria";
        public static final boolean IS_ABSTRACT = false;
        public static final String OPTIONAL_PROP_NAME = "tsql:optional";
        public static final Class<?> OPTIONAL_PROP_TYPE = Boolean.class;
        public static final boolean OPTIONAL_PROP_MULTIPLE = false;
        public static final String RIGHT_EXPRESSION_REF_NAME = "tsql:rightExpression";
        public static final Class<?> RIGHT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean RIGHT_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface AbstractCompareCriteria
    extends Criteria,
    PredicateCriteria {
        public static final String ID = "tsql:abstractCompareCriteria";
        public static final boolean IS_ABSTRACT = true;
        public static final String OPERATOR_PROP_NAME = "tsql:operator";
        public static final Class<?> OPERATOR_PROP_TYPE = String.class;
        public static final boolean OPERATOR_PROP_MULTIPLE = false;
        public static final String[] OPERATOR_PROP_CONSTRAINTS = new String[]{"EQ", "NE", "LT", "GT", "LE", "GE"};
        public static final String LEFT_EXPRESSION_REF_NAME = "tsql:leftExpression";
        public static final Class<?> LEFT_EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean LEFT_EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface Criteria
    extends Expression {
        public static final String ID = "tsql:criteria";
        public static final boolean IS_ABSTRACT = false;
    }

    public static interface Labeled {
        public static final String ID = "tsql:labeled";
        public static final String LABEL_PROP_NAME = "tsql:label";
        public static final Class<?> LABEL_PROP_TYPE = String.class;
        public static final boolean LABEL_PROP_MULTIPLE = false;
    }

    public static interface TargetedCommand {
        public static final String ID = "tsql:targetedCommand";
        public static final String GROUP_REF_NAME = "tsql:group";
        public static final Class<?> GROUP_REF_TYPE = GroupSymbol.class;
        public static final boolean GROUP_REF_MULTIPLE = false;
    }

    public static interface SubqueryContainer
    extends LanguageObject {
        public static final String ID = "tsql:subqueryContainer";
        public static final String COMMAND_REF_NAME = "tsql:command";
        public static final Class<?> COMMAND_REF_TYPE = Command.class;
        public static final boolean COMMAND_REF_MULTIPLE = false;
    }

    public static interface IsDistinctCriteria
    extends PredicateCriteria {
        public static final String ID = "tsql:isDistinctCriteria";
        public static final String NEGATED_PROP_NAME = "tsql:negated";
        public static final Class<?> NEGATED_PROP_TYPE = Boolean.class;
        public static final boolean NEGATED_PROP_MULTIPLE = false;
        public static final String LEFT_ROW_VALUE_REF_NAME = "tsql:leftRowValue";
        public static final Class<?> LEFT_ROW_VALUE_REF_TYPE = GroupSymbol.class;
        public static final boolean LEFT_ROW_VALUE_REF_MULTIPLE = false;
        public static final String RIGHT_ROW_VALUE_REF_NAME = "tsql:leftRowValue";
        public static final Class<?> RIGHT_ROW_VALUE_REF_TYPE = GroupSymbol.class;
        public static final boolean RIGHT_ROW_VALUE_REF_MULTIPLE = false;
    }

    public static interface PredicateCriteria
    extends Expression {
        public static final String ID = "tsql:predicateCriteria";
    }

    public static interface Expression
    extends LanguageObject {
        public static final String ID = "tsql:expression";
        public static final String TYPE_CLASS_PROP_NAME = "tsql:typeClass";
        public static final Class<?> TYPE_CLASS_PROP_TYPE = String.class;
        public static final boolean TYPE_CLASS_PROP_MULTIPLE = false;
    }

    public static interface LanguageObject {
        public static final String ID = "tsql:languageObject";
        public static final String TEIID_VERSION_PROP_NAME = "tsql:teiidVersion";
        public static final Class<?> TEIID_VERSION_PROP_TYPE = String.class;
        public static final boolean TEIID_VERSION_PROP_MULTIPLE = false;
    }

    public static interface ExpressionStatement {
        public static final String ID = "tsql:expressionStatement";
        public static final String EXPECTED_TYPE_CLASS_PROP_NAME = "tsql:expectedTypeClass";
        public static final Class<?> EXPECTED_TYPE_CLASS_PROP_TYPE = String.class;
        public static final boolean EXPECTED_TYPE_CLASS_PROP_MULTIPLE = false;
        public static final String EXPRESSION_REF_NAME = "tsql:expression";
        public static final Class<?> EXPRESSION_REF_TYPE = Expression.class;
        public static final boolean EXPRESSION_REF_MULTIPLE = false;
    }

    public static interface Namespace {
        public static final String PREFIX = "tsql";
        public static final String URI = "http://www.teiid.org/sql/1.0";
    }
}

