/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.outcome;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.komodo.spi.Messages;
import org.komodo.spi.outcome.Outcome;

public class OutcomeFactory {
    private static OutcomeFactory instance;

    public static OutcomeFactory getInstance() {
        if (instance == null) {
            instance = new OutcomeFactory();
        }
        return instance;
    }

    public Outcome createMultiOutcome(String message, List<Outcome> outcomes) {
        OutcomeImpl multiOutcome = new OutcomeImpl();
        multiOutcome.setMessage(message);
        multiOutcome.setLevel(Outcome.Level.OK);
        multiOutcome.addOutcomes(outcomes);
        return multiOutcome;
    }

    public Outcome createOK() {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(Messages.getString(Messages.OutcomeFactory.OK, new Object[0]));
        outcome.setLevel(Outcome.Level.OK);
        return outcome;
    }

    public Outcome createOK(String msg) {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(msg);
        outcome.setLevel(Outcome.Level.OK);
        return outcome;
    }

    public Outcome createError(String msg) {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(msg);
        outcome.setLevel(Outcome.Level.ERROR);
        return outcome;
    }

    public Outcome createError(String msg, Exception ex) {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(msg);
        outcome.setException(ex);
        outcome.setLevel(Outcome.Level.ERROR);
        return outcome;
    }

    public Outcome createWarning(String msg) {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(msg);
        outcome.setLevel(Outcome.Level.WARNING);
        return outcome;
    }

    public Outcome createInformation(String msg, Exception ex) {
        OutcomeImpl outcome = new OutcomeImpl();
        outcome.setMessage(msg);
        outcome.setException(ex);
        outcome.setLevel(Outcome.Level.INFO);
        return outcome;
    }

    public static class OutcomeImpl
    implements Outcome {
        private List<Outcome> children;
        private String message;
        private Exception exception;
        private Outcome.Level level;

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        @Override
        public Outcome.Level getLevel() {
            return this.level;
        }

        public void setLevel(Outcome.Level level) {
            this.level = level;
        }

        @Override
        public boolean isOK() {
            return Outcome.Level.OK == this.level;
        }

        @Override
        public List<Outcome> getOutcomes() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return this.children;
        }

        @Override
        public void addOutcome(Outcome outcome) {
            if (this.children == null) {
                this.children = new ArrayList<Outcome>();
            }
            if (outcome.isMultiOutcome()) {
                this.addOutcomes(outcome.getOutcomes());
            } else {
                this.children.add(outcome);
                if (this.children.size() == 1) {
                    this.setMessage(outcome.getMessage());
                }
            }
            Outcome.Level addedLevel = outcome.getLevel();
            if (this.isGreaterThanCurrent(addedLevel)) {
                this.setLevel(addedLevel);
            }
        }

        @Override
        public void addOutcomes(List<Outcome> outcomes) {
            for (Outcome outcome : outcomes) {
                this.addOutcome(outcome);
            }
        }

        @Override
        public boolean isMultiOutcome() {
            return this.children != null && !this.children.isEmpty();
        }

        private boolean isGreaterThanCurrent(Outcome.Level level) {
            Outcome.Level currentLevel = this.getLevel();
            boolean isGreater = false;
            switch (level) {
                case OK: {
                    isGreater = false;
                    break;
                }
                case INFO: {
                    if (currentLevel != Outcome.Level.OK) break;
                    isGreater = true;
                    break;
                }
                case WARNING: {
                    if (currentLevel != Outcome.Level.OK && currentLevel != Outcome.Level.INFO) break;
                    isGreater = true;
                    break;
                }
                case ERROR: {
                    if (currentLevel != Outcome.Level.OK && currentLevel != Outcome.Level.INFO && currentLevel != Outcome.Level.ERROR) break;
                    isGreater = true;
                    break;
                }
            }
            return isGreater;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            if (!this.isMultiOutcome()) {
                sb.append("\n\t").append("isMulti = ").append(this.isMultiOutcome());
                sb.append("\n\t").append("Level   = ").append((Object)this.getLevel());
                sb.append("\n\t").append("Msg     = ").append(this.getMessage());
            } else {
                sb.append("\n\t").append("isMulti = ").append(this.isMultiOutcome());
                sb.append(" (").append(this.getOutcomes().size()).append(" outcomes)");
                sb.append("\n\t").append("Max Level = ").append((Object)this.getLevel());
                sb.append("\n\t").append("Msg = ").append(this.getMessage());
            }
            return sb.toString();
        }
    }
}

