/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.komodo.spi.annotation.AnnotationUtils;
import org.komodo.spi.runtime.version.TeiidVersion;

public interface CriteriaOperator {

    public static enum Operator {
        EQ("="),
        NE("<>", "!="),
        LT("<"),
        GT(">"),
        LE("<="),
        GE(">=");

        private Collection<String> symbols = new ArrayList<String>();

        private Operator(String ... symbols) {
            this.getSymbols().addAll(Arrays.asList(symbols));
        }

        public String toString() {
            String symbol = this.getSymbols().iterator().next();
            if (symbol == null || symbol.length() == 0) {
                return "??";
            }
            return symbol;
        }

        public int getIndex() {
            return this.ordinal() + 1;
        }

        public Collection<String> getSymbols() {
            return this.symbols;
        }

        public boolean isLessThan(Operator other) {
            return this.getIndex() < other.getIndex();
        }

        public boolean isGreaterThan(Operator other) {
            return this.getIndex() > other.getIndex();
        }

        public static Operator findOperator(int index) {
            for (Operator op : Operator.values()) {
                if (op.getIndex() != index) continue;
                return op;
            }
            throw new IllegalStateException();
        }

        public static Operator getOperator(TeiidVersion version, String symbol) {
            for (Operator operator : Operator.values()) {
                boolean foundSymbol = false;
                for (String opSymbol : operator.getSymbols()) {
                    if (!opSymbol.equalsIgnoreCase(symbol)) continue;
                    foundSymbol = true;
                    break;
                }
                if (!foundSymbol || !AnnotationUtils.isApplicable(operator, version)) continue;
                return operator;
            }
            throw new UnsupportedOperationException("Symbol '" + symbol + "' has no operator in version " + version);
        }

        public static Operator findOperator(String name) {
            if (name == null) {
                return null;
            }
            name = name.toUpperCase();
            for (Operator operator : Operator.values()) {
                if (!operator.name().equals(name)) continue;
                return operator;
            }
            return null;
        }
    }
}

