/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.query;

public enum JoinTypeTypes {
    JOIN_INNER(false),
    JOIN_RIGHT_OUTER(true),
    JOIN_LEFT_OUTER(true),
    JOIN_FULL_OUTER(true),
    JOIN_CROSS(false),
    JOIN_UNION(true),
    JOIN_SEMI(false),
    JOIN_ANTI_SEMI(true);

    private final boolean outer;

    private JoinTypeTypes(boolean outer) {
        this.outer = outer;
    }

    public int getTypeCode() {
        return this.ordinal();
    }

    public boolean isOuter() {
        return this.outer;
    }

    public String toPrintStatement() {
        String name = this.name();
        String JOIN = "JOIN";
        name = name.substring((JOIN + "_").length());
        name = name.replaceAll("_", " ");
        name = name + " " + JOIN;
        return name;
    }

    public static JoinTypeTypes findType(String name) {
        if (name == null) {
            return null;
        }
        name = name.toUpperCase();
        for (JoinTypeTypes type : JoinTypeTypes.values()) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static JoinTypeTypes findType(int index) {
        for (JoinTypeTypes type : JoinTypeTypes.values()) {
            if (type.ordinal() != index) continue;
            return type;
        }
        return null;
    }
}

