/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.repository;

import org.komodo.spi.constants.StringConstants;

public class DocumentType
implements StringConstants {
    public static final DocumentType VDB_XML = new DocumentType("-vdb.xml");
    public static final DocumentType CONNECTION = new DocumentType("-connection.xml");
    public static final DocumentType ZIP = new DocumentType("zip");
    public static final DocumentType DDL = new DocumentType("ddl");
    public static final DocumentType JAR = new DocumentType("jar");
    public static final DocumentType UNKNOWN = new DocumentType("");
    private String type;

    public DocumentType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public String fileName(String name) {
        if (name.endsWith("." + this.type)) {
            return name;
        }
        if (this.type.contains(".")) {
            return name + this.type;
        }
        return name + "." + this.type;
    }

    public static DocumentType createDocumentType(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        if (name.endsWith("-vdb.xml")) {
            return VDB_XML;
        }
        if (name.endsWith("-connection.xml")) {
            return CONNECTION;
        }
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return UNKNOWN;
        }
        String suffix = name.substring(dotIndex + 1);
        return new DocumentType(suffix);
    }

    public static DocumentType documentType(String docTypeValue) {
        return new DocumentType(docTypeValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentType other = (DocumentType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

