/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public enum KomodoType {
    DATASERVICE("dataservice"),
    CONNECTION("connection"),
    DRIVER("driver"),
    FOLDER,
    SCHEMA,
    TEIID,
    CACHED_TEIID,
    VDB("vdb"),
    VDB_ENTRY("entry"),
    VDB_IMPORT("import-vdb", "importVdb"),
    VDB_MODEL_SOURCE("source"),
    VDB_TRANSLATOR("translator"),
    VDB_CONDITION("condition"),
    VDB_DATA_ROLE("data-role", "dataRole"),
    VDB_MASK("mask"),
    VDB_PERMISSION("permission"),
    ACCESS_PATTERN,
    COLUMN,
    FOREIGN_KEY,
    PUSHDOWN_FUNCTION,
    USER_DEFINED_FUNCTION,
    INDEX,
    MODEL("model"),
    PARAMETER,
    PRIMARY_KEY,
    STORED_PROCEDURE,
    VIRTUAL_PROCEDURE,
    DATA_TYPE_RESULT_SET,
    RESULT_SET_COLUMN,
    TABULAR_RESULT_SET,
    STATEMENT_OPTION,
    TABLE,
    UNIQUE_CONSTRAINT,
    VIEW,
    DDL_SCHEMA,
    TSQL_SCHEMA,
    VDB_SCHEMA,
    WORKSPACE,
    SERVER_MANAGER,
    UNKNOWN,
    RESOURCE,
    DDL_FILE,
    UDF_FILE,
    VDB_DATA_SERVICE_ENTRY,
    CONNECTION_ENTRY,
    DRIVER_ENTRY,
    DDL_ENTRY,
    RESOURCE_ENTRY,
    UDF_ENTRY;

    private Collection<String> aliases;
    public static final KomodoType[] NO_TYPES;

    private KomodoType() {
    }

    private KomodoType(String ... aliases) {
        this();
        if (aliases != null) {
            this.aliases = new ArrayList<String>(aliases.length);
            for (String alias : aliases) {
                this.aliases.add(alias);
            }
        }
    }

    public String getType() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.name().split("_")) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
        }
        return sb.toString();
    }

    public Collection<String> getAliases() {
        if (this.aliases == null) {
            return Collections.emptyList();
        }
        return this.aliases;
    }

    public String toString() {
        return this.getType();
    }

    public static KomodoType getKomodoType(String kType) {
        if (kType == null) {
            return UNKNOWN;
        }
        for (KomodoType value : KomodoType.values()) {
            if (value.getType().equalsIgnoreCase(kType)) {
                return value;
            }
            if (!value.getAliases().contains(kType)) continue;
            return value;
        }
        return UNKNOWN;
    }

    public static List<String> getTypes() {
        ArrayList<String> names = new ArrayList<String>();
        for (KomodoType kType : KomodoType.values()) {
            names.add(kType.getType());
        }
        return names;
    }

    static {
        NO_TYPES = new KomodoType[0];
    }
}

