/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.repository;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Artifact;
import org.komodo.spi.repository.ArtifactDescriptor;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.RepositoryClient;
import org.komodo.spi.repository.RepositoryClientEvent;
import org.komodo.spi.repository.RepositoryObserver;
import org.komodo.spi.repository.ValidationManager;

public interface Repository {
    public static final String SYSTEM_USER = "SYSTEM";

    public void provision(UnitOfWork var1, KomodoObject var2, OperationType var3) throws KException;

    public KomodoObject add(UnitOfWork var1, String var2, String var3, String var4) throws KException;

    public void addClient(RepositoryClient var1);

    public void addObserver(RepositoryObserver var1);

    public UnitOfWork createTransaction(String var1, String var2, boolean var3, UnitOfWorkListener var4) throws KException;

    public List<KomodoObject> query(UnitOfWork var1, String var2) throws KException;

    public List<KomodoObject> searchByKeyword(UnitOfWork var1, String var2, String var3, KeywordCriteria var4, String ... var5) throws KException;

    public List<KomodoObject> searchByType(UnitOfWork var1, String ... var2) throws KException;

    public List<KomodoObject> searchByPath(UnitOfWork var1, String var2) throws KException;

    public KomodoObject getFromWorkspace(UnitOfWork var1, String var2) throws KException;

    public KomodoObject getUsingId(UnitOfWork var1, String var2) throws KException;

    public Id getId();

    public State getState();

    public Type getType();

    public ValidationManager getValidationManager() throws KException;

    public KomodoObject importFile(UnitOfWork var1, File var2, String var3, String var4) throws KException;

    public KomodoObject importResource(UnitOfWork var1, URL var2, String var3, String var4) throws KException;

    public void notify(RepositoryClientEvent var1);

    public boolean ping();

    public void publish(UnitOfWork var1, boolean var2, ArtifactDescriptor var3, KomodoObject var4) throws KException;

    public void remove(UnitOfWork var1, String ... var2) throws KException;

    public void removeClient(RepositoryClient var1);

    public void removeObserver(RepositoryObserver var1);

    public Artifact[] retrieve(UnitOfWork var1, String ... var2) throws KException;

    public void unpublish(UnitOfWork var1, String ... var2) throws KException;

    public KomodoObject komodoSearches(UnitOfWork var1) throws KException;

    public KomodoObject komodoEnvironment(UnitOfWork var1) throws KException;

    public KomodoObject komodoLibrary(UnitOfWork var1) throws KException;

    public KomodoObject komodoWorkspace(UnitOfWork var1) throws KException;

    public KomodoObject komodoTeiidCache(UnitOfWork var1) throws KException;

    public KomodoObject komodoServersNode(UnitOfWork var1) throws KException;

    public static interface UnitOfWorkListener {
        public void errorOccurred(Throwable var1);

        public void respond(Object var1);
    }

    public static interface UnitOfWork {
        public void commit();

        public UnitOfWorkListener getCallback();

        public KException getError();

        public String getUserName();

        public String getName();

        public State getState();

        public boolean hasChanges() throws KException;

        public boolean isRollbackOnly();

        public void rollback();

        public String decode(String var1);

        public static enum State {
            COMMITTED,
            ERROR,
            NOT_STARTED,
            ROLLED_BACK,
            RUNNING;


            public boolean isFinal() {
                return this == COMMITTED || this == ERROR || this == ROLLED_BACK;
            }
        }
    }

    public static enum Type {
        LOCAL,
        SHARED;

    }

    public static enum State {
        NOT_REACHABLE,
        REACHABLE;

    }

    public static enum KeywordCriteria {
        ALL,
        ANY,
        NONE;


        public static KeywordCriteria getDefault() {
            return ANY;
        }
    }

    public static interface Id {
        public URL getConfiguration();

        public String getUrl();

        public String getWorkspaceName();
    }

    public static enum OperationType {
        READ_OPERATION,
        CHILD_OPERATION,
        MODIFY_OPERATION,
        REMOVE_OPERATION;

    }
}

