/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.repository;

import org.komodo.spi.repository.RepositoryClient;

public final class RepositoryClientEvent {
    private final EventType eventType;
    private final RepositoryClient source;

    public RepositoryClientEvent(EventType eventType, RepositoryClient source) {
        this.eventType = eventType;
        this.source = source;
    }

    public EventType getType() {
        return this.eventType;
    }

    public RepositoryClient getSource() {
        return this.source;
    }

    public static RepositoryClientEvent createStartedEvent(RepositoryClient source) {
        return new RepositoryClientEvent(EventType.STARTED, source);
    }

    public static RepositoryClientEvent createShuttingDownEvent(RepositoryClient source) {
        return new RepositoryClientEvent(EventType.SHUTTING_DOWN, source);
    }

    public static RepositoryClientEvent createClearEvent(RepositoryClient source) {
        return new RepositoryClientEvent(EventType.CLEAR, source);
    }

    public static enum EventType {
        STARTED,
        SHUTTING_DOWN,
        CLEAR;

    }
}

