/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.repository.validation;

import java.util.Map;
import org.komodo.spi.KException;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.repository.validation.Result;

public interface Rule {
    public static final Rule[] NO_RULES = new Rule[0];

    public Result evaluate(Repository.UnitOfWork var1, KomodoObject var2) throws KException;

    public String getDescription(Repository.UnitOfWork var1) throws KException;

    public String getJcrName(Repository.UnitOfWork var1) throws KException;

    public String getMessage(Repository.UnitOfWork var1, String var2) throws KException;

    public String getName(Repository.UnitOfWork var1) throws KException;

    public String getNodeType(Repository.UnitOfWork var1) throws KException;

    public Map<String, String> getPropRestrictions(Repository.UnitOfWork var1, PropertyRestriction var2) throws KException;

    public RuleType getRuleType(Repository.UnitOfWork var1) throws KException;

    public Outcome.Level getSeverity(Repository.UnitOfWork var1) throws KException;

    public ValidationType getValidationType(Repository.UnitOfWork var1) throws KException;

    public boolean isRequired(Repository.UnitOfWork var1) throws KException;

    public boolean isApplicable(Repository.UnitOfWork var1, KomodoObject var2) throws KException;

    public void setRequired(Repository.UnitOfWork var1, boolean var2) throws KException;

    public boolean isEnabled(Repository.UnitOfWork var1) throws KException;

    public void setEnabled(Repository.UnitOfWork var1, boolean var2) throws KException;

    public void setSeverity(Repository.UnitOfWork var1, Outcome.Level var2) throws KException;

    public static enum PropertyRestriction {
        CHILD,
        NODE;

    }

    public static enum ValidationType {
        CHILD,
        NODE,
        PROPERTY;

    }

    public static enum RuleType {
        NUMBER,
        PATTERN,
        RELATIONSHIP,
        SAME_NAME_SIBLING;

    }

    public static enum MessageKey {
        CHILD_COUNT_ABOVE_MAX_VALUE,
        CHILD_COUNT_BELOW_MIN_VALUE,
        CHILD_OF_REQUIRED_TYPE_NOT_FOUND,
        DESCRIPTION,
        NUMBER_RULE_HAS_NO_VALUES,
        NUMBER_RULE_NON_NUMERIC_VALUES,
        PATTERN_RULE_INVALID_NODE_NAME,
        PATTERN_RULE_INVALID_PROPERTY_VALUE,
        PROPERTY_RULE_ABSENT_CHILD_FOUND,
        PROPERTY_RULE_ABSENT_PROPERTY_FOUND,
        PROPERTY_RULE_REQUIRED_CHILD_NOT_FOUND,
        PROPERTY_RULE_REQUIRED_PROPERTY_NOT_FOUND,
        PROPERTY_RULE_VALUE_ABOVE_MAX_VALUE,
        PROPERTY_RULE_VALUE_BELOW_MIN_VALUE,
        RELATIONSHIP_RULE_ABSENT_CHILD_FOUND,
        RELATIONSHIP_RULE_ABSENT_PROPERTY_FOUND,
        RELATIONSHIP_RULE_REQUIRED_CHILD_NOT_FOUND,
        RELATIONSHIP_RULE_REQUIRED_PROPERTY_NOT_FOUND,
        RELATIONSHIP_RULE_SNS_FOUND,
        REQUIRED_PROPERTY_NOT_FOUND;

    }
}

