/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.runtime;

import java.io.File;
import java.io.InputStream;
import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidPropertyDefinition;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;

public interface ExecutionAdmin
extends StringConstants {
    public static final String PING_VDB_NAME = "ping";
    public static final String PING_VDB = "ping-vdb.xml";

    public void connect() throws Exception;

    public void disconnect();

    public boolean dataSourceExists(String var1) throws Exception;

    public void deleteDataSource(String var1) throws Exception;

    public TeiidDataSource getDataSource(String var1) throws Exception;

    public Collection<TeiidDataSource> getDataSources() throws Exception;

    public Set<String> getDataSourceTypeNames() throws Exception;

    public TeiidDataSource getOrCreateDataSource(String var1, String var2, String var3, Properties var4) throws Exception;

    public TeiidTranslator getTranslator(String var1) throws Exception;

    public Collection<TeiidTranslator> getTranslators() throws Exception;

    public Collection<TeiidVdb> getVdbs() throws Exception;

    public Collection<String> getVdbNames() throws Exception;

    public TeiidVdb getVdb(String var1) throws Exception;

    public boolean hasVdb(String var1) throws Exception;

    public boolean isVdbActive(String var1) throws Exception;

    public boolean isVdbLoading(String var1) throws Exception;

    public boolean hasVdbFailed(String var1) throws Exception;

    public boolean wasVdbRemoved(String var1) throws Exception;

    public List<String> retrieveVdbValidityErrors(String var1) throws Exception;

    public void undeployVdb(String var1) throws Exception;

    public Outcome ping(ConnectivityType var1) throws Exception;

    public String getAdminDriverPath() throws Exception;

    public Driver getTeiidDriver(String var1) throws Exception;

    public void deployDynamicVdb(String var1, InputStream var2) throws Exception;

    public void undeployDynamicVdb(String var1) throws Exception;

    public void deployDriver(String var1, File var2) throws Exception;

    public void undeployDriver(String var1) throws Exception;

    public String getSchema(String var1, String var2, String var3) throws Exception;

    public Properties getDataSourceProperties(String var1) throws Exception;

    public Set<String> getDataSourceTemplateNames() throws Exception;

    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String var1) throws Exception;

    public static enum ConnectivityType {
        ADMIN,
        JDBC;


        public static ConnectivityType findType(String type) {
            if (type == null) {
                return null;
            }
            for (ConnectivityType cType : ConnectivityType.values()) {
                if (!type.equalsIgnoreCase(cType.name())) continue;
                return cType;
            }
            return null;
        }
    }
}

