/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.runtime;

import org.komodo.spi.Messages;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidTranslator;

public final class ExecutionConfigurationEvent {
    private final EventType eventType;
    private final TargetType targetType;
    private final Object target;
    private final Object updatedTarget;

    public static ExecutionConfigurationEvent createAddDataSourceEvent(TeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createAddTeiidEvent(TeiidInstance teiidInstance) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.TINSTANCE, teiidInstance);
    }

    public static ExecutionConfigurationEvent createDeployVDBEvent(String vdbName) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.VDB, vdbName);
    }

    public static ExecutionConfigurationEvent createRemoveDataSourceEvent(TeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createRemoveTeiidEvent(TeiidInstance teiidInstance) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.TINSTANCE, teiidInstance);
    }

    public static ExecutionConfigurationEvent createTeiidRefreshEvent(TeiidInstance teiidInstance) {
        return new ExecutionConfigurationEvent(EventType.REFRESH, TargetType.TINSTANCE, teiidInstance);
    }

    public static ExecutionConfigurationEvent createTeiidConnectedEvent(TeiidInstance teiidInstance) {
        return new ExecutionConfigurationEvent(EventType.CONNECTED, TargetType.TINSTANCE, teiidInstance);
    }

    public static ExecutionConfigurationEvent createSetDefaultTeiidEvent(TeiidInstance oldDefaultInstance, TeiidInstance newDefaultInstance) {
        return new ExecutionConfigurationEvent(EventType.DEFAULT, TargetType.TINSTANCE, oldDefaultInstance, newDefaultInstance);
    }

    public static ExecutionConfigurationEvent createUnDeployVDBEvent(String vdbName) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.VDB, vdbName);
    }

    public static ExecutionConfigurationEvent createUpdateDataSourceEvent(TeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.UPDATE, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createUpdateTeiidEvent(TeiidInstance teiidInstance, TeiidInstance updatedInstance) {
        return new ExecutionConfigurationEvent(EventType.UPDATE, TargetType.TINSTANCE, teiidInstance, updatedInstance);
    }

    private ExecutionConfigurationEvent(EventType eventType, TargetType targetType, Object target) {
        this(eventType, targetType, target, null);
        if (target == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.SPI.valueCannotBeNull, "target"));
        }
    }

    private ExecutionConfigurationEvent(EventType eventType, TargetType targetType, Object target, Object updatedTarget) {
        assert (eventType != null);
        assert (targetType != null);
        this.eventType = eventType;
        this.targetType = targetType;
        this.target = target;
        this.updatedTarget = updatedTarget;
    }

    private ExecutionConfigurationEvent(TargetType targetType) {
        this(EventType.REFRESH, targetType, null, null);
    }

    public TeiidDataSource getDataSource() {
        if (this.targetType != TargetType.DATA_SOURCE) {
            throw new IllegalStateException(Messages.getString(Messages.SPI.invalidTargetTypeForGetDataSourceMethod, new Object[]{this.targetType, TargetType.DATA_SOURCE}));
        }
        return (TeiidDataSource)this.target;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public TeiidInstance getTeiidInstance() {
        if (this.targetType != TargetType.TINSTANCE) {
            throw new IllegalStateException(Messages.getString(Messages.SPI.invalidTargetTypeForGetTeiidMethod, new Object[]{this.targetType, TargetType.TINSTANCE}));
        }
        return (TeiidInstance)this.target;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public TeiidTranslator getTranslator() {
        if (this.targetType != TargetType.TRANSLATOR) {
            throw new IllegalStateException(Messages.getString(Messages.SPI.invalidTargetTypeForGetTranslatorMethod, new Object[]{this.targetType, TargetType.TRANSLATOR}));
        }
        return (TeiidTranslator)this.target;
    }

    public TeiidInstance getUpdatedInstance() {
        if (this.targetType != TargetType.TINSTANCE) {
            throw new IllegalStateException(Messages.getString(Messages.SPI.invalidTargetTypeForGetUpdatedTeiidMethod, new Object[]{this.targetType, TargetType.TINSTANCE}));
        }
        return (TeiidInstance)this.updatedTarget;
    }

    public static enum TargetType {
        TRANSLATOR,
        DATA_SOURCE,
        TINSTANCE,
        VDB,
        SOURCE_BINDING;

    }

    public static enum EventType {
        ADD,
        CONNECTED,
        REFRESH,
        REMOVE,
        UPDATE,
        DEFAULT;

    }
}

