/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.runtime;

import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.runtime.ExecutionAdmin;
import org.komodo.spi.runtime.HostProvider;

public interface TeiidConnectionInfo {
    public static final String JDBC_PROTOCOL_PREFIX = "jdbc:teiid:";
    public static final String MMS = "mms://";
    public static final String MM = "mm://";
    public static final String VDB_GENERIC_NAME = "<vdbname>";

    public String getPassword();

    public int getPort();

    public ExecutionAdmin.ConnectivityType getType();

    public HostProvider getHostProvider();

    public String getUrl();

    public String getUsername();

    public boolean isSecure();

    public void setHostProvider(HostProvider var1);

    public void setPassword(String var1);

    public void setPort(int var1);

    public void setSecure(boolean var1);

    public void setUsername(String var1);

    public static class UrlConstructor
    implements StringConstants {
        public static String createTeiidConnectionUrl(String vdbName, boolean secure, String host, int port) {
            if (vdbName == null) {
                vdbName = TeiidConnectionInfo.VDB_GENERIC_NAME;
            }
            String protocol = TeiidConnectionInfo.MM;
            if (secure) {
                protocol = TeiidConnectionInfo.MMS;
            }
            if (host == null) {
                host = "localhost";
            }
            if (port == -1) {
                port = 31000;
            }
            StringBuffer buf = new StringBuffer(TeiidConnectionInfo.JDBC_PROTOCOL_PREFIX).append(vdbName).append("@").append(protocol).append(host).append(":").append(port);
            return buf.toString();
        }

        public static String createDefaultTeiidConnectionUrl() {
            return UrlConstructor.createTeiidConnectionUrl(null, false, null, -1);
        }
    }
}

