/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.runtime.version;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.komodo.spi.Messages;
import org.komodo.spi.runtime.version.TeiidVersion;

public class DefaultTeiidVersion
implements TeiidVersion {
    private String versionString = "0.0.0";
    private final String majorVersion;
    private String minorVersion = "x";
    private String microVersion = "x";

    private static TeiidVersion extractDefaultVersion() {
        InputStream fileStream = DefaultTeiidVersion.class.getClassLoader().getResourceAsStream("default-teiid-version.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream));
        try {
            DefaultTeiidVersion version;
            String line = reader.readLine();
            if (line == null) {
                throw new RuntimeException("Programming error: The default version id cannot be null");
            }
            DefaultTeiidVersion defaultTeiidVersion = version = new DefaultTeiidVersion(line);
            return defaultTeiidVersion;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public DefaultTeiidVersion(String major, String minor, String micro) {
        if (major == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.SPI.valueCannotBeNull, "major"));
        }
        if (minor == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.SPI.valueCannotBeNull, "minor"));
        }
        if (micro == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.SPI.valueCannotBeNull, "micro"));
        }
        this.majorVersion = major;
        this.minorVersion = minor;
        this.microVersion = micro;
        this.versionString = major + "." + minor + "." + micro;
    }

    public DefaultTeiidVersion(String versionString) {
        this.versionString = versionString;
        String[] tokens = versionString.split("\\.");
        if (tokens.length >= 3) {
            this.majorVersion = tokens[0];
            this.minorVersion = tokens[1];
            if (tokens[2] != null) {
                int dashIndex = tokens[2].indexOf(45);
                this.microVersion = dashIndex != -1 && tokens[2].length() > 0 ? tokens[2].substring(0, dashIndex) : tokens[2];
            }
        } else if (tokens.length == 2) {
            this.majorVersion = tokens[0];
            this.minorVersion = tokens[1];
        } else {
            this.majorVersion = tokens[0];
        }
        this.versionString = this.majorVersion + "." + this.minorVersion + "." + this.microVersion;
    }

    public String toString() {
        return this.versionString;
    }

    @Override
    public String getMajor() {
        return this.majorVersion;
    }

    @Override
    public String getMinor() {
        return this.minorVersion;
    }

    @Override
    public String getMicro() {
        return this.microVersion;
    }

    @Override
    public boolean hasWildCards() {
        return this.majorVersion.equals("x") || this.minorVersion.equals("x") || this.microVersion.equals("x");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
        result = 31 * result + (this.microVersion == null ? 0 : this.microVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTeiidVersion other = (DefaultTeiidVersion)obj;
        if (this.majorVersion == null ? other.majorVersion != null : !this.majorVersion.equals(other.majorVersion)) {
            return false;
        }
        if (this.microVersion == null ? other.microVersion != null : !this.microVersion.equals(other.microVersion)) {
            return false;
        }
        return !(this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion));
    }

    @Override
    public boolean compareTo(TeiidVersion otherVersion) {
        String entryMajor = otherVersion.getMajor();
        if (!(this.getMajor().equals(entryMajor) || this.getMajor().equals("x") || entryMajor.equals("x"))) {
            return false;
        }
        String entryMinor = otherVersion.getMinor();
        if (!(this.getMinor().equals(entryMinor) || this.getMinor().equals("x") || entryMinor.equals("x"))) {
            return false;
        }
        String entryMicro = otherVersion.getMicro();
        return this.getMicro().equals(entryMicro) || this.getMicro().equals("x") || entryMicro.equals("x");
    }

    @Override
    public boolean isSevenInstance() {
        return "7".equals(this.getMajor());
    }

    @Override
    public TeiidVersion getMinimumVersion() {
        if (!this.hasWildCards()) {
            return this;
        }
        String major = this.getMajor().equals("x") ? "7" : this.getMajor();
        String minor = this.getMinor().equals("x") ? "0" : this.getMinor();
        String micro = this.getMicro().equals("x") ? "0" : this.getMicro();
        return new DefaultTeiidVersion(major, minor, micro);
    }

    @Override
    public TeiidVersion getMaximumVersion() {
        if (!this.hasWildCards()) {
            return this;
        }
        String major = this.getMajor().equals("x") ? "9" : this.getMajor();
        String minor = this.getMinor().equals("x") ? "9" : this.getMinor();
        String micro = this.getMicro().equals("x") ? "9" : this.getMicro();
        return new DefaultTeiidVersion(major, minor, micro);
    }

    @Override
    public boolean isGreaterThan(TeiidVersion otherVersion) {
        TeiidVersion myMinVersion = this.getMinimumVersion();
        TeiidVersion otherMaxVersion = otherVersion.getMaximumVersion();
        int majCompResult = this.isOtherNumberGreaterThan(myMinVersion.getMajor(), otherMaxVersion.getMajor());
        if (majCompResult > 0) {
            return true;
        }
        int minCompResult = this.isOtherNumberGreaterThan(myMinVersion.getMinor(), otherMaxVersion.getMinor());
        if (majCompResult == 0 && minCompResult > 0) {
            return true;
        }
        int micCompResult = this.isOtherNumberGreaterThan(myMinVersion.getMicro(), otherMaxVersion.getMicro());
        return majCompResult == 0 && minCompResult == 0 && micCompResult > 0;
    }

    @Override
    public boolean isGreaterThan(Version otherVersion) {
        return this.isGreaterThan(otherVersion.get());
    }

    @Override
    public boolean isLessThan(TeiidVersion otherVersion) {
        int micCompResult;
        int minCompResult;
        int majCompResult;
        TeiidVersion myMaxVersion = this.getMaximumVersion();
        TeiidVersion otherMinVersion = otherVersion.getMinimumVersion();
        try {
            int myMax = Integer.parseInt(myMaxVersion.getMajor());
            int otherMin = Integer.parseInt(otherMinVersion.getMajor());
            majCompResult = Integer.valueOf(myMax).compareTo(otherMin);
        }
        catch (NumberFormatException ex) {
            majCompResult = myMaxVersion.getMajor().compareTo(otherMinVersion.getMajor());
        }
        if (majCompResult < 0) {
            return true;
        }
        try {
            int myMax = Integer.parseInt(myMaxVersion.getMinor());
            int otherMin = Integer.parseInt(otherMinVersion.getMinor());
            minCompResult = Integer.valueOf(myMax).compareTo(otherMin);
        }
        catch (NumberFormatException ex) {
            minCompResult = myMaxVersion.getMinor().compareTo(otherMinVersion.getMinor());
        }
        if (majCompResult == 0 && minCompResult < 0) {
            return true;
        }
        try {
            int myMax = Integer.parseInt(myMaxVersion.getMicro());
            int otherMin = Integer.parseInt(otherMinVersion.getMicro());
            micCompResult = Integer.valueOf(myMax).compareTo(otherMin);
        }
        catch (NumberFormatException ex) {
            micCompResult = myMaxVersion.getMicro().compareTo(otherMinVersion.getMicro());
        }
        return majCompResult == 0 && minCompResult == 0 && micCompResult < 0;
    }

    @Override
    public boolean isLessThan(Version otherVersion) {
        return this.isLessThan(otherVersion.get());
    }

    @Override
    public boolean isGreaterThanOrEqualTo(TeiidVersion otherVersion) {
        return this.compareTo(otherVersion) || this.isGreaterThan(otherVersion);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Version otherVersion) {
        return this.isGreaterThanOrEqualTo(otherVersion.get());
    }

    @Override
    public boolean isLessThanOrEqualTo(TeiidVersion otherVersion) {
        return this.compareTo(otherVersion) || this.isLessThan(otherVersion);
    }

    @Override
    public boolean isLessThanOrEqualTo(Version otherVersion) {
        return this.isLessThan(otherVersion.get());
    }

    private int isOtherNumberGreaterThan(String myNumber, String otherNumber) {
        int myValue = -1;
        int otherValue = -1;
        try {
            myValue = Integer.parseInt(myNumber);
        }
        catch (NumberFormatException e) {
            myValue = -1;
        }
        try {
            otherValue = Integer.parseInt(otherNumber);
        }
        catch (NumberFormatException e) {
            otherValue = -1;
        }
        if (myValue < 0 || otherValue < 0) {
            return myNumber.compareTo(otherNumber);
        }
        return myValue - otherValue;
    }

    static /* synthetic */ TeiidVersion access$000() {
        return DefaultTeiidVersion.extractDefaultVersion();
    }

    public static enum Version {
        DEFAULT_TEIID_VERSION(DefaultTeiidVersion.access$000()),
        TEIID_7_7(TeiidVersion.VersionID.TEIID_7_7),
        TEIID_8_0(TeiidVersion.VersionID.TEIID_8_0),
        TEIID_8_1(TeiidVersion.VersionID.TEIID_8_1),
        TEIID_8_2(TeiidVersion.VersionID.TEIID_8_2),
        TEIID_8_3(TeiidVersion.VersionID.TEIID_8_3),
        TEIID_8_4(TeiidVersion.VersionID.TEIID_8_4),
        TEIID_8_5(TeiidVersion.VersionID.TEIID_8_5),
        TEIID_8_6(TeiidVersion.VersionID.TEIID_8_6),
        TEIID_8_7(TeiidVersion.VersionID.TEIID_8_7),
        TEIID_8_8(TeiidVersion.VersionID.TEIID_8_8),
        TEIID_8_9(TeiidVersion.VersionID.TEIID_8_9),
        TEIID_8_10(TeiidVersion.VersionID.TEIID_8_10),
        TEIID_8_11(TeiidVersion.VersionID.TEIID_8_11),
        TEIID_8_11_5(TeiidVersion.VersionID.TEIID_8_11_5),
        TEIID_8_12(TeiidVersion.VersionID.TEIID_8_12),
        TEIID_8_12_4(TeiidVersion.VersionID.TEIID_8_12_4),
        TEIID_8_12_7(TeiidVersion.VersionID.TEIID_8_12_7),
        TEIID_8_13(TeiidVersion.VersionID.TEIID_8_13),
        TEIID_9_0(TeiidVersion.VersionID.TEIID_9_0),
        TEIID_9_1(TeiidVersion.VersionID.TEIID_9_1),
        TEIID_9_1_1(TeiidVersion.VersionID.TEIID_9_1_1);

        private final TeiidVersion version;

        private Version(TeiidVersion version) {
            this.version = version;
        }

        private Version(TeiidVersion.VersionID id) {
            this.version = new DefaultTeiidVersion(id.toString());
        }

        public TeiidVersion get() {
            return this.version;
        }
    }
}

