/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.storage;

import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.repository.Exportable;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.storage.StorageConnectorId;
import org.komodo.spi.storage.StorageTree;

public interface StorageConnector
extends StringConstants {
    public static final String FILES_HOME_PATH_PROPERTY = "files-home-path-property";
    public static final String FILE_PATH_PROPERTY = "file-path-property";
    public static final String DOWNLOADABLE_PATH_PROPERTY = "downloadable-path-property";

    public StorageConnectorId getId();

    public Set<Descriptor> getDescriptors();

    public void write(Exportable var1, Repository.UnitOfWork var2, Properties var3) throws Exception;

    public boolean refresh() throws Exception;

    public InputStream read(Properties var1) throws Exception;

    public StorageTree<String> browse() throws Exception;

    public void dispose();

    public static class Descriptor {
        private String name;
        private boolean required;
        private String description;
        private boolean encoded = false;

        public Descriptor(String name, boolean required, boolean encoded, String description) {
            this.name = name;
            this.required = required;
            this.description = description;
            this.encoded = encoded;
        }

        public Descriptor(String name, boolean required, String description) {
            this(name, required, false, description);
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEncoded() {
            return this.encoded;
        }
    }
}

