/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.storage.StorageNode;

public abstract class StorageParent<T>
implements StringConstants {
    private final StorageParent<T> parent;
    private List<StorageNode<T>> children;

    public StorageParent(StorageParent<T> parent) {
        this.parent = parent;
    }

    public StorageParent<T> getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<StorageNode<T>> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public StorageNode<T> addChild(T data) {
        if (this.children == null) {
            this.children = new ArrayList<StorageNode<T>>();
        }
        StorageNode<T> child = new StorageNode<T>(this, data);
        this.children.add(child);
        return child;
    }

    public abstract String getPath();

    public String printTree() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString()).append("\n");
        for (StorageNode<T> child : this.getChildren()) {
            buf.append(child.printTree());
        }
        return buf.toString();
    }

    public String toString() {
        return this.getPath();
    }
}

