/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.type;

import java.util.Set;
import org.komodo.spi.constants.StringConstants;

public interface DataTypeManager
extends StringConstants {
    public static final String ARRAY_SUFFIX = "[]";

    public String getDataSourceType(DataSourceTypes var1);

    public Class<?> getDataTypeClass(String var1);

    public DataTypeName getDataTypeName(String var1);

    public String getDataTypeName(Class<?> var1);

    public DataTypeName retrieveDataTypeName(Class<?> var1);

    public Set<String> getAllDataTypeNames();

    public Class<?> getDefaultDataClass(DataTypeName var1);

    public boolean isExplicitConversion(String var1, String var2);

    public boolean isImplicitConversion(String var1, String var2);

    public boolean isTransformable(String var1, String var2);

    public <T> T transformValue(Object var1, DataTypeName var2) throws Exception;

    public <T> T transformValue(Object var1, Class<?> var2) throws Exception;

    public boolean isLOB(Class<?> var1);

    public static enum DataSourceTypes {
        JDBC("connector-jdbc"),
        SALESFORCE("salesforce"),
        LDAP("ldap"),
        FILE("file"),
        MONGODB("mongodb"),
        JDBC_XA("connector-jdbc-xa"),
        WS("webservice"),
        UNKNOWN("connector-unknown");

        private String id;

        private DataSourceTypes(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }

    public static enum DataTypeAliases {
        VARCHAR("varchar"),
        TINYINT("tinyint"),
        SMALLINT("smallint"),
        BIGINT("bigint"),
        REAL("real"),
        DECIMAL("decimal");

        private String id;

        private DataTypeAliases(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum DataTypeName {
        STRING,
        STRING_ARRAY,
        BOOLEAN,
        BOOLEAN_ARRAY,
        BYTE,
        BYTE_ARRAY,
        SHORT,
        SHORT_ARRAY,
        CHAR,
        CHAR_ARRAY,
        INTEGER,
        INTEGER_ARRAY,
        LONG,
        LONG_ARRAY,
        BIGINTEGER,
        BIGINTEGER_ARRAY,
        FLOAT,
        FLOAT_ARRAY,
        DOUBLE,
        DOUBLE_ARRAY,
        BIGDECIMAL,
        BIGDECIMAL_ARRAY,
        DATE,
        DATE_ARRAY,
        TIME,
        TIME_ARRAY,
        TIMESTAMP,
        TIMESTAMP_ARRAY,
        OBJECT,
        OBJECT_ARRAY,
        NULL,
        NULL_ARRAY,
        BLOB,
        BLOB_ARRAY,
        CLOB,
        CLOB_ARRAY,
        XML,
        XML_ARRAY,
        VARCHAR,
        VARCHAR_ARRAY,
        TINYINT,
        TINYINT_ARRAY,
        SMALLINT,
        SMALLINT_ARRAY,
        BIGINT,
        BIGINT_ARRAY,
        REAL,
        REAL_ARRAY,
        DECIMAL,
        DECIMAL_ARRAY,
        VARBINARY,
        VARBINARY_ARRAY;

        private static final String ARRAY_SUFFIX = "_ARRAY";

        public boolean isArrayType() {
            return this.name().endsWith(ARRAY_SUFFIX);
        }

        public DataTypeName getComponentType() {
            if (this.isArrayType()) {
                String rootName = this.name().substring(0, this.name().indexOf(ARRAY_SUFFIX));
                return DataTypeName.findDataTypeName(rootName);
            }
            return this;
        }

        public DataTypeName getArrayType() {
            if (this.isArrayType()) {
                return this;
            }
            String arrayTypeName = this.name() + ARRAY_SUFFIX;
            return DataTypeName.findDataTypeName(arrayTypeName);
        }

        public static DataTypeName findDataTypeName(String name) {
            if (name == null) {
                return NULL;
            }
            name = DataTypeName.correctBigUnderscores(name);
            name = name.toUpperCase();
            for (DataTypeName dtn : DataTypeName.values()) {
                if (!dtn.name().equals(name)) continue;
                return dtn;
            }
            return null;
        }

        public String getId() {
            return this.name().toLowerCase();
        }

        public static String correctBigUnderscores(String name) {
            if (name == null) {
                return null;
            }
            return name.toLowerCase().replace("big_", "big");
        }
    }
}

