/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.utils;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyInValueHashMap<K, V>
extends AbstractMap<K, V> {
    private Set<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
    private KeyFromValueAdapter<K, V> adapter;

    public KeyInValueHashMap(KeyFromValueAdapter<K, V> adapter) {
        this.adapter = adapter;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Use add rather than put since the key is part of the value");
    }

    public boolean add(V value) {
        EntryWrapper entry = new EntryWrapper(value);
        return this.entrySet.add(entry);
    }

    @Override
    public V remove(Object value) {
        EntryWrapper entry = new EntryWrapper(value);
        if (this.entrySet.remove(entry)) {
            return (V)value;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    private class EntryWrapper
    implements Map.Entry<K, V> {
        V value;

        public EntryWrapper(V value) {
            this.value = value;
        }

        @Override
        public K getKey() {
            return KeyInValueHashMap.this.adapter.getKey(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryWrapper other = (EntryWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        private KeyInValueHashMap<K, V> getOuterType() {
            return KeyInValueHashMap.this;
        }
    }

    public static interface KeyFromValueAdapter<K, V> {
        public K getKey(V var1);
    }
}

