/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.utils;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TextFormat {
    public static final int DEFAULT_SIZE = -1;
    private static final int BOLD = 0;
    private static final int ITALIC = 1;
    private static final int UNDERLINE = 2;
    private Alignment alignment;
    private Rgb bgColor;
    private Rgb fgColor;
    private final Map<String, Object> props = new HashMap<String, Object>();
    private int size;
    private final BitSet style = new BitSet(3);
    private TextCase textCase;

    public void bold() {
        this.style.set(0);
    }

    public Alignment getAlignment() {
        return this.alignment == null ? Alignment.DEFAULT : this.alignment;
    }

    public Rgb getBackground() {
        return this.bgColor;
    }

    public Object getCustomPropert(String propName) {
        if (propName != null && !propName.isEmpty()) {
            return this.props.get(propName);
        }
        return null;
    }

    public Map<String, Object> getCustomProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public Rgb getForeground() {
        return this.fgColor;
    }

    public int getSize() {
        if (this.size == 0 || this.size < -1) {
            return -1;
        }
        return this.size;
    }

    public TextCase getTextCase() {
        return this.textCase == null ? TextCase.DEFAULT : this.textCase;
    }

    public boolean isBold() {
        return this.style.get(0);
    }

    public boolean isItalic() {
        return this.style.get(1);
    }

    public boolean isUnderline() {
        return this.style.get(2);
    }

    public void italic() {
        this.style.set(1);
    }

    public void reset() {
        this.alignment = Alignment.DEFAULT;
        this.bgColor = null;
        this.fgColor = null;
        this.size = -1;
        this.style.clear();
        this.textCase = TextCase.DEFAULT;
    }

    public void setAlignment(Alignment newAlignment) {
        this.alignment = newAlignment;
    }

    public void setBackground(Rgb newBackground) {
        this.bgColor = newBackground;
    }

    public void setCustomProperty(String propName, Object value) {
        if (propName != null && !propName.isEmpty()) {
            if (value == null) {
                this.props.remove(propName);
            } else {
                this.props.put(propName, value);
            }
        }
    }

    public void setForeground(Rgb newForeground) {
        this.fgColor = newForeground;
    }

    public void setTextCase(TextCase newTextCase) {
        this.textCase = newTextCase;
    }

    public void unBold() {
        this.style.clear(0);
    }

    public void underline() {
        this.style.set(2);
    }

    public void unItalic() {
        this.style.clear(1);
    }

    public void unUnderline() {
        this.style.clear(2);
    }

    public static enum TextCase {
        AS_IS,
        CAMEL,
        LOWER,
        LOWER_CAMEL,
        UPPER;

        static final TextCase DEFAULT;

        static {
            DEFAULT = AS_IS;
        }
    }

    public static class Rgb {
        public static final Rgb BLACK = new Rgb(0, 0, 0);
        public static final Rgb BLUE = new Rgb(0, 0, 255);
        public static final Rgb CYAN = new Rgb(0, 255, 255);
        public static final Rgb DARK_GRAY = new Rgb(64, 64, 64);
        public static final Rgb GRAY = new Rgb(128, 128, 128);
        public static final Rgb GREEN = new Rgb(0, 255, 0);
        public static final Rgb LIGHT_GRAY = new Rgb(192, 192, 192);
        public static final Rgb MAGENTA = new Rgb(255, 0, 255);
        public static final Rgb ORANGE = new Rgb(255, 200, 0);
        public static final Rgb PINK = new Rgb(255, 175, 175);
        public static final Rgb RED = new Rgb(255, 0, 0);
        public static final Rgb WHITE = new Rgb(255, 255, 255);
        public static final Rgb YELLOW = new Rgb(255, 255, 0);
        private final int blue;
        private final int green;
        private final int red;

        public Rgb(int redComponent, int greenComponent, int blueComponent) {
            this.red = redComponent < 0 ? 0 : redComponent;
            this.green = greenComponent < 0 ? 0 : greenComponent;
            this.blue = blueComponent < 0 ? 0 : blueComponent;
        }

        public int getBlue() {
            return this.red;
        }

        public int getGreen() {
            return this.red;
        }

        public int getRed() {
            return this.red;
        }

        public String toString() {
            return "RGB(" + this.red + ", " + this.green + ", " + this.blue + ')';
        }
    }

    public static enum Alignment {
        AS_IS,
        BLOCK,
        CENTER,
        LEFT,
        RIGHT;

        static final Alignment DEFAULT;

        static {
            DEFAULT = AS_IS;
        }
    }
}

