/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.spi.uuid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.UUID;

public class WorkspaceUUIDService {
    private static WorkspaceUUIDService instance;
    private File restoreFile;

    public static WorkspaceUUIDService getInstance() {
        if (instance == null) {
            instance = new WorkspaceUUIDService();
        }
        return instance;
    }

    private WorkspaceUUIDService() {
    }

    public void setRestoreLocation(File file) {
        this.restoreFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        UUID workspaceUuid = null;
        if (this.restoreFile != null && this.restoreFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.restoreFile));
                workspaceUuid = UUID.fromString(reader.readLine());
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (workspaceUuid == null) {
            workspaceUuid = UUID.randomUUID();
        }
        this.writeUUID(workspaceUuid);
        return workspaceUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUUID(UUID workspaceUuid) {
        if (this.restoreFile == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(this.restoreFile);
            writer.write(workspaceUuid.toString());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

