/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.spi.query.TeiidService;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.teiid.TeiidServiceProvider;

public class TestDataTypeManager {
    private TeiidVersion version = TeiidVersionProvider.getInstance().getTeiidVersion();

    protected DataTypeManager getDataTypeManager(TeiidVersion version) throws Exception {
        TeiidService teiidService = TeiidServiceProvider.getInstance().getTeiidService(version);
        Assert.assertNotNull((Object)teiidService);
        return teiidService.getDataTypeManager();
    }

    @Test
    public void testGetDataType() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.NULL, (Object)manager.getDataTypeName((String)null));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.STRING, (Object)manager.getDataTypeName("string"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.STRING, (Object)manager.getDataTypeName("STRING"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.STRING_ARRAY, (Object)manager.getDataTypeName("String[]"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.BIGDECIMAL, (Object)manager.getDataTypeName("bigdecimal"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.BIGDECIMAL, (Object)manager.getDataTypeName("BIG_DECIMAL"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.BIGDECIMAL_ARRAY, (Object)manager.getDataTypeName("BIG_DECIMAL[]"));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.OBJECT, (Object)manager.getDataTypeName("NoSuchObject"));
    }

    @Test
    public void testGetDataTypeClass() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)"NullType", (Object)manager.getDataTypeClass((String)null).getSimpleName());
        Assert.assertSame(String.class, (Object)manager.getDataTypeClass("string"));
        Assert.assertSame(String.class, (Object)manager.getDataTypeClass("STRING"));
        Assert.assertSame(String[].class, (Object)manager.getDataTypeClass("String[]"));
        Assert.assertSame(Object.class, (Object)manager.getDataTypeClass("NoSuchObject"));
    }

    @Test
    public void testGetDefaultDataTypeClass() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)"NullType", (Object)manager.getDefaultDataClass(null).getSimpleName());
        Assert.assertSame(String.class, (Object)manager.getDefaultDataClass(DataTypeManager.DataTypeName.STRING));
        Assert.assertSame(Object.class, (Object)manager.getDefaultDataClass(DataTypeManager.DataTypeName.OBJECT));
    }

    @Test
    public void testGetDataType4Class() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.LONG.getId(), (Object)manager.getDataTypeName(Long.class));
        Assert.assertEquals((Object)DataTypeManager.DataTypeName.STRING.getId(), (Object)manager.getDataTypeName(String.class));
    }

    @Test
    public void testGetDataSourceType() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertSame((Object)DataTypeManager.DataSourceTypes.JDBC.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.JDBC));
        Assert.assertSame((Object)DataTypeManager.DataSourceTypes.UNKNOWN.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.UNKNOWN));
    }

    @Test
    public void testGetDataType1() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertSame((Object)DataTypeManager.DataTypeName.VARBINARY, (Object)manager.getDataTypeName("varbinary"));
    }

    @Test
    public void testGetDataTypeClass1() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)"BinaryType", (Object)manager.getDataTypeClass("varbinary").getSimpleName());
    }

    @Test
    public void testGetDefaultDataTypeClass1() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)"BinaryType", (Object)manager.getDefaultDataClass(DataTypeManager.DataTypeName.VARBINARY).getSimpleName());
    }

    @Test
    public void testGetAllDataTypeNames() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Set names = manager.getAllDataTypeNames();
        Assert.assertTrue((!names.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)names.contains(DataTypeManager.DataTypeName.BIGDECIMAL.getId()));
        Assert.assertTrue((boolean)names.contains(DataTypeManager.DataTypeName.STRING.getId()));
        Assert.assertTrue((boolean)names.contains(DataTypeManager.DataTypeName.VARBINARY.getId()));
    }

    @Test
    public void testGetDataSourceType1() throws Exception {
        DataTypeManager manager = this.getDataTypeManager(this.version);
        Assert.assertEquals((Object)DataTypeManager.DataSourceTypes.SALESFORCE.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.SALESFORCE));
        Assert.assertEquals((Object)DataTypeManager.DataSourceTypes.LDAP.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.LDAP));
        Assert.assertEquals((Object)DataTypeManager.DataSourceTypes.FILE.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.FILE));
        Assert.assertEquals((Object)DataTypeManager.DataSourceTypes.WS.id(), (Object)manager.getDataSourceType(DataTypeManager.DataSourceTypes.WS));
    }
}

